import java.applet.Applet;
import java.awt.*;

public class Moko75 extends Applet {
boolean go;
double time;
Animation[] a = new Animation[5];
int count = 0;
Image offimage;
Graphics offgraphics;
public void update(Graphics g) {
int w = getSize().width, h = getSize().height;
if(offimage == null) {
offimage = createImage(w, h);
offgraphics = offimage.getGraphics();
}
offgraphics.setColor(getBackground());
offgraphics.fillRect(0, 0, w, h);
paint(offgraphics);
g.drawImage(offimage, 0, 0, this);
}
public void init() {
a[count++] = new Ground(Color.white, 150, 195, 300, 10);
a[count++] = new Snowman(150, 40, 150, 130, 30);
}
public void paint(Graphics g) {
g.setColor(new Color(0, 0, 0));
g.fillRect(0, 0,300, 190);
for(int i = 0; i < count; ++i) { a[i].draw(g); }
}
public void start() { go = true; (new Thread(new MyRun())).start(); }
public void stop() { go = false; }
class MyRun implements Runnable {
public void run() {
time = 0.001 * System.currentTimeMillis();
while(go) {
try { Thread.sleep(100); } catch(Exception e) { }
double dt = 0.001 * System.currentTimeMillis() - time;
for(int i = 0; i < count; ++i) { a[i].addTime(dt); }
time += dt; repaint();
}
}
}
interface Animation {
public void addTime(double dt);
public void draw(Graphics g);
}
static class Snowman implements Animation{
double hx, hy, bx, by, rad;
public Snowman(double x1, double y1,double x2, double y2, double r){
hx = x1; hy = y1; bx = x2; by = y2; rad = r;
}
public void addTime(double dt) {
hx += 0.8*dt;
hy += 3.7*dt;
rad -= dt;
}
public void draw(Graphics g) {
g.setColor(new Color(255, 255, 255));
g.fillOval((int)(hx-rad), (int)(hy-rad), (int)(2*rad), (int)(2*rad));
g.fillOval((int)(bx-2*rad), (int)(by-2*rad), (int)(4*rad), (int)(4*rad));
g.setColor(new Color(0, 0, 0));
g.fillOval((int)(hx-3*rad/5), (int)(hy-3*rad/5), (int)(2*rad/5),
(int)(2*rad/5));
g.fillOval((int)(hx+rad/5), (int)(hy-3*rad/5), (int)(2*rad/5),
(int)(2*rad/5));
g.fillOval((int)(bx-rad/4), (int)(by-5*rad/4),(int)(rad/2), (int)(rad/2));
g.fillOval((int)(bx-rad/4), (int)(by-rad/4), (int)(rad/2), (int)(rad/2));
g.fillOval((int)(bx-rad/4), (int)(by+3*rad/4), (int)(rad/2), (int)(rad/2));
g.setColor(new Color(230, 110, 103));
g.fillOval((int)(hx-rad/3), (int)(hy-rad/3), (int)(2*rad/3),
(int)(2*rad/3));
}
}
static class Ground implements Animation {
Color col;
double gx, gy, width, height;
public Ground (Color c, double x, double y, double w, double h) {
col = c; gx = x; gy = y; width = w; height = h;
}
public void addTime(double dt) {
height += 4.2*dt;
}
public void draw(Graphics g) {
g.setColor(col);
g.fillRect((int)(gx-width/2), (int)(gy-height/2), (int)(width),
(int)(height));
}
}
}