import java.awt.*;
import java.awt.geom.*;
import java.applet.Applet;

public class Amoeba extends Applet
{
	boolean go;
	double clock;
	Animation[] a = new Animation[2];

	public void init(){
		a[0] = new amoeba(100, 300, 50, 12, 1.5,
			8, -8, new Color(20, 100, 0));
		a[1] = new amoeba(50, 50, 40, 10, 1,
			10, 0, new Color(40, 100, 0));
	}

	public void paint(Graphics g){
		Graphics2D g2 = (Graphics2D)g;
		for (int i = 0; i < 2; i++){
			a[i].draw(g2);
		}
	}

	public void start(){
		go = true;
		(new Thread(new MyRun())).start();
	}

	class MyRun implements Runnable
	{
		public void run(){
			clock = 0.001 * System.currentTimeMillis();
			while (go){
				try { Thread.sleep(150); }
				catch (Exception e){ }
				double dt = 0.001 * System.currentTimeMillis() -clock;
				for (int i = 0; i < 2; i++){
					a[i].addtime(dt);
				}
				clock += dt;
				repaint();
			}
		}
	}

	interface Animation
	{
		public void addtime(double TIME);
		public void draw(Graphics2D G2);
	}

	static class amoeba implements Animation
	{
		double rad;
		int points;
		double time, speed;
		double vx, vy;
		double xPos, yPos;
		Color col;
		double[] EndAngle = new double[20];
		double[] EndAngleTo = new double[20];
		double[] EndStretch = new double[20];
		double[] EndStretchTo = new double[20];
		double[] ArmStretch = new double[20];
		double[] ArmStretchTo = new double[20];

		public amoeba(double XPOS, double YPOS, double RAD, int POINTS,
			double SPEED, double VX, double VY, Color COL){
			time = 0;
			xPos = XPOS;
			yPos = YPOS;
			rad = RAD;
			points = POINTS;
			speed = SPEED;
			vx = VX;
			vy = VY;
			col = COL;
			double around = 0;
			EndAngle[0] = Math.PI / points + 2 * Math.PI / points
				* Math.random();
			EndAngleTo[0] = Math.PI / points + 2 * Math.PI / points
				* Math.random() - EndAngle[0];
			EndStretch[0] = rad / 2 + rad * Math.random();
			EndStretchTo[0] = rad / 2 + rad * Math.random() - EndStretch[0];
			ArmStretch[0] = rad / 2 + rad  * Math.random();
			ArmStretchTo[0] = rad / 2 + rad  * Math.random()
				- ArmStretch[0];
			for (int i = 1; i < points; i++){
				EndAngle[i] = Math.PI / points
					+ 2 * Math.PI / points * Math.random();
				EndAngleTo[i] = Math.PI / points + 2 * Math.PI
					/ points * Math.random() - EndAngle[i];
				EndStretch[i] = rad / 2 + rad * Math.random();
				EndStretchTo[i] = rad / 2 + rad * Math.random()
					- EndStretch[i];
				ArmStretch[i] = rad / 2 + rad * Math.random();
				ArmStretchTo[i] = rad / 2 + rad * Math.random()
					- ArmStretch[i];
				around += EndAngle[i];
			}
		}

		public void move(double DX, double DY){
			xPos += DX; yPos += DY;
		}

		public void squirm(double TIME){
			for (int i = 0; i < points; i++){
				EndAngle[i] += EndAngleTo[i] / speed * TIME;
				EndStretch[i] += EndStretchTo[i] / speed * TIME;
				ArmStretch[i] += ArmStretchTo[i] / speed * TIME;
			}
			time += TIME;
			if (time > speed){
				time = 0;
				for (int i = 0; i < points; i++){
					EndAngleTo[i] = Math.PI / points + 2 * Math.PI
						/ points * Math.random() - EndAngle[i];
					EndStretchTo[i] = rad / 2 + rad * Math.random()
						- EndStretch[i];
					ArmStretchTo[i] = rad / 2 + rad * Math.random()
						- ArmStretch[i];
				}
			}
		}

		public void addtime(double TIME){
			squirm(TIME);
			move(vx * TIME, vy * TIME);
		}

		public void draw(Graphics2D G2){
			GeneralPath outline = new GeneralPath();
			outline.moveTo((float)(EndStretch[0] * Math.cos(EndAngle[0])),
				(float)(EndStretch[0] * Math.sin(EndAngle[0])));
			double around = EndAngle[0];
			int i = 1;
			while (around < 2 * Math.PI && i < points){
				outline.quadTo(
					(float)(ArmStretch[i] * Math.cos(around+ EndAngle[i]/2)),
					(float)(ArmStretch[i] * Math.sin(around+ EndAngle[i]/2)),
					(float)(EndStretch[i] * Math.cos(around+ EndAngle[i])),
					(float)(EndStretch[i] * Math.sin(around+ EndAngle[i])));
				around += EndAngle[i];
				i++;
			}
			outline.quadTo(
				(float)(ArmStretch[0] * Math.cos((around
					- 2 * Math.PI + EndAngle[0]) / 2)),
				(float)(ArmStretch[0] * Math.sin((around
					- 2 * Math.PI + EndAngle[0]) / 2)),
				(float)(EndStretch[0] * Math.cos(EndAngle[0])),
				(float)(EndStretch[0] * Math.sin(EndAngle[0])));
			outline.closePath();
			G2.translate(xPos, yPos);
			G2.setPaint(col);
			G2.fill(outline);
			G2.translate(-xPos, -yPos);
		}
	}
}

