// Animation12.java

import java.applet.*;
import java.awt.*;
import java.awt.event.*;

public class Animation12 extends Applet {

    MyThread thread = null;
    int x, y, width, height;
    double time;
    Button resumeButton, suspendButton;
    boolean threadSuspended = false;

    public void init() {
	x = 100;
	y = 50;
	width = getSize().width;
	height = getSize().height - 80;
	time = 0;
	resumeButton = new Button("Resume");
	suspendButton = new Button("Suspend");
	add(resumeButton);
	add(suspendButton);
	resumeButton.addActionListener(new ActionAdp());
	suspendButton.addActionListener(new ActionAdp());
    }

    public void start() {
	if (thread == null) {
	    thread = new MyThread();
	    thread.start();
	}
    }

    public void stop() {
	thread = null;
    }

    public void paint(Graphics g) {
	g.setColor(Color.red);
	g.fillOval(x, y, 50, 50);
	g.setColor(Color.black);
	g.drawLine(0, height + 79, width, height + 79);
    }

    class ActionAdp implements ActionListener {
	public void actionPerformed(ActionEvent e) {
	    if (e.getSource() == resumeButton) {
		threadSuspended = false;
		thread.myResume();
	    } else if (e.getSource() == suspendButton) { 
		threadSuspended = true;
	    }
	}
    }

    class MyThread extends Thread {

	public void run() {
	    Thread thisThread = Thread.currentThread();
	    while (thread == thisThread) {
		while (threadSuspended) {
		    synchronized(this) {
			try {
			    wait();
			} catch (InterruptedException e) {
			}
		    }
		}
		repaint();
		try {
		    if (time >= 2.0) {
			time = -2.0;
		    }
		    y = (int) (height * time * time / 4 + 30);
		    time += 0.05;
		    thread.sleep(50);
		} catch (InterruptedException e) {
		}
	    }
	}

	public synchronized void myResume() {
	    notify();
	}

    }

}

