import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;

public class Coulomb extends Applet {
  static final int minX = 0, minY = 0, maxX = 300, maxY = 300;
  double time = 0;
  boolean running = false;

  Circle c1 = new Circle(Color.yellow, 30, 100, 38, 60, 15, 2, 80);
  Circle c2 = new Circle(Color.blue, 190, 190, -60, -40, 20, 5, 70);
  Circle c3 = new Circle(Color.red, 180, 45, 80, -7, 8, 1.5, 10);
  Circle cl1 = c1, cl2 = c2,  cl3 = c3;

  public void start() {
    if(!running) {
      (new Thread(new MyRun())).start();
      running = true;
    }
  }

  public void stop() {running = false;}

  class MyRun implements Runnable{
    public void run() {
      long t0 = System.currentTimeMillis();
      while(running) {

        try{
          Thread.sleep(100);
        }catch(Exception ex){}

        long t1 = System.currentTimeMillis();
        double dt = 0.001*(t1-t0);
        time += 0.001*(t1-t0);
        t0 = t1;
        cl1.clone(c1);
        cl2.clone(c2);
        cl3.clone(c3);
        c1.passTime(dt, c2, c3);
        c2.passTime(dt, c1, c3);
        c3.passTime(dt, c1, c2);
        time += dt;
        repaint();
      }
    }
  }

  public void paint(Graphics g) {
    g.setColor(Color.black);
    g.drawRect(0,0,maxX,maxY);
    c1.draw(g);
    c2.draw(g);
    c3.draw(g);
  }

  static class Circle {
    Color c;
    int cX,cY;
    double vX,vY;
    int radius;
    double mass,q;
    static final double k = 600;

    public Circle(Color c, int cX, int cY, int vX, int vY,
                  int radius, double mass, double q) {
      this.c = c;
      this.cX = cX;
      this.cY = cY;
      this.vX = vX;
      this.vY = vY;
      this.radius = radius;
      this.mass = mass;
      this.q = q;
    }

    public void clone(Circle c) {
      this.cX = c.cX;
      this.cY = c.cY;
      this.q = c.q;
    }

    public void draw(Graphics g) {
      g.setColor(c);
      g.fillOval(cX - radius, cY - radius, radius*2, radius*2);
    }

    public void passTime(double dt, Circle c1, Circle c2) {
      this.cX = this.cX+(int)(this.vX*dt); //ړ
      this.cY = this.cY+(int)(this.vY*dt);
      this.vX = this.vX-dt*(this.forceX(c1) + this.forceX(c2))/this.mass; //
      this.vY = this.vY-dt*(this.forceY(c1) + this.forceY(c2))/this.mass;
      if(vX < 0 && cX <= minX+radius) {
        vX = -vX;
        cX = (int)((minX+radius)*2-cX); //߂荞݂CAˌ̍W
      }//
      if(vX > 0 && cX >= maxX-radius) {
        vX = -vX;
        cX = (int)((maxX-radius)*2-cX);
      }
      if(vY < 0 && cY <= minY+radius) {
        vY = -vY;
        cY = (int)((minY+radius)*2-cY);
      }
      if(vY > 0 && cY >= maxY-radius) {
        vY = -vY;
        cY = (int)((maxY-radius)*2-cY);
      }
    }

    public double forceX(Circle ci) {
    //̗q󂯂ÓdC͂̌vZ
      double r = Math.sqrt((ci.cX-this.cX)*(ci.cX-this.cX)
                 +(ci.cY-this.cY)*(ci.cY-this.cY));
      r = Math.max(10, r); //[̃G[шُh~
      return k*this.q*ci.q*(ci.cX - this.cX)/(r*r*r);
    }

    public double forceY(Circle ci) {
      double r = Math.sqrt((ci.cX-this.cX)*(ci.cX-this.cX)
                 +(ci.cY-this.cY)*(ci.cY-this.cY));
      r = Math.max(10, r);
      return k*this.q*ci.q*(ci.cY - this.cY)/(r*r*r);

    }
  }
}
