import java.applet.Applet;
import java.awt.*;
import java.awt.image.*;

public class Exercise710 extends Applet {
   boolean go;
   double time;
   Animation[] a = new Animation[20];
   int count = 0;
   public void init() {
     a[count++] = new Light(255, 0, 0, 50, 100, 40, 25, 40);
     a[count++] = new Light(255, 200, 0, 100, 80, 30, -30, 20);
     a[count++] = new Light(0, 255, 100, 150, 60, 25, 0, 10);
     a[count++] = new Light(0, 100, 255, 200, 40, 20, 30, 30);
     a[count++] = new Flame(new Color(255, 0, 0, 130), 50, 100, 20, 40);
     a[count++] = new Flame(new Color(255, 200, 0, 130), 100, 80, 15,30);
     a[count++] = new Flame(new Color(50, 255, 100, 170), 150, 60, 12.5,25);
     a[count++] = new Flame(new Color(0, 100, 255, 130), 200, 40, 10,20);
   }
   Dai d0 = new Dai(Color.gray, 50, 100, 20, 40);
   Dai d1 = new Dai(Color.gray, 100, 80, 15, 30);
   Dai d2 = new Dai(Color.gray, 150, 60, 12.5, 25);
   Dai d3 = new Dai(Color.gray, 200, 40, 10, 20);
   public void paint(Graphics g) {
     d0.draw(g); d1.draw(g); d2.draw(g); d3.draw(g);
     for(int i = count-1; i >= 0; --i) a[i].draw(g, this);
   }
   public void start() { go = true; (new Thread(new MyRun())).start(); }
   public void stop() { go = false; }
   class MyRun implements Runnable {
     public void run() {
       time = 0.001 * System.currentTimeMillis();
       while(go) {
         try { Thread.sleep(70); } catch(Exception e) { }
         double dt = 0.001 * System.currentTimeMillis() - time;
         for(int i = count-1; i >= 0; --i) a[i].addTime(dt);
         time += dt; repaint();
       }
     }
   }
   interface Animation {
     public void addTime(double dt);
     public void draw(Graphics g, ImageObserver o);
   }
   static class Flame implements Animation {
     double gx, gy, width, height;
     BufferedImage img;

     public Flame(Color c, double x, double y, double w, double h) {
       gx = x; gy = y; width = w; height = h;
       img = new BufferedImage((int)w,(int)h,
BufferedImage.TYPE_INT_ARGB);
       Graphics g = img.getGraphics(); g.setColor(c);
       for(int x1 = 0; x1 < (int)w; ++x1) {
         for(int y1 = 0; y1 < (int)h; ++y1) {
           if(x1 >= (int)((w/4)*(Math.cos(3*Math.PI*y1/(2*h)) + 1)) &&x1 <= (int)((w/4)*(-Math.cos(3*Math.PI*y1/(2*h)) + 3))) g.fillRect(x1,y1, 1, 1);
         }
       }
     }
     public void addTime(double dt) {
     }
     public void draw(Graphics g, ImageObserver o) {
       g.drawImage(img, (int)(gx-width/2), (int)(gy-height/2), o);
     }
   }
   static class Light implements Animation {
     static final int MAX_X = 300, MAX_Y = 200;
     double gx, gy, rad, vx, vy;
     int red, green, blue;
     BufferedImage img;

     public Light(int re, int gre, int bl, double x, double y, double r,
                   double vx1, double vy1) {
       red = re; green = gre; blue = bl; gx = x; gy = y; rad = r; vx =vx1; vy = vy1;
       img = new
BufferedImage((int)r*2,(int)r*2,BufferedImage.TYPE_INT_ARGB);
       Graphics g = img.getGraphics();
       for(int x1 = 0; x1 < (int)r*2; ++x1) {
         for(int y1 = 0; y1 < (int)r*2; ++y1) {
           double r2 = (x1-r)*(x1-r) + (y1-r)*(y1-r);
           if(r2 < r*r) g.setColor(new Color(re, gre, bl,(int)(130*(r*r-r2)/(r*r)))); g.fillRect(x1, y1, 1, 1);
         }
       }
     }
     public void addTime(double dt) {
       gx += vx*dt; gy += vy*dt;
       if(vx < 0 || vx > 0) vx = -vx;
       if(vy < 0 || vy > 0) vy = -vy;
     }
     public void draw(Graphics g, ImageObserver o) {
       g.drawImage(img, (int)(gx-rad), (int)(gy-rad), o);
     }
   }
   static class Dai {
     Color col;
     double xpos, ypos, width, height;
     public Dai(Color c, double x, double y, double w, double h) {
       col = c; xpos = x; ypos = y; width = w; height = h;
     }
     public void draw(Graphics g) {
       g.setColor(col);
       for(int i = 0; i <= (int)height; ++i) {
         g.fillOval((int)(xpos-width/2), (int)(ypos+height/2) + i,(int)width, (int)(width/4));
       }
     }
   }
}
