
import java.applet.Applet;
import java.awt.*;

public class Kanon extends Applet {
  boolean go;
  double time;
  Animation[] A = new Animation[10];
  public void init() {
    for(int i = 0; i < 10; ++i) {
      Color c = new Color(250-5*i, 250-5*i, 255);
      double xpos = Math.random()*300;
      double ypos = Math.random()*200;
      double radi = 3.0 + Math.random()*3;
      double ampl = Math.random()*50;
      double phas = Math.random()*2*Math.PI;
      A[i] = new FallingCircle(c, xpos, ypos, radi, ampl, phas);
    }
  }
  public void paint(Graphics g) {
    for(int i = 0; i < 10; ++i) A[i].draw(g);
  }
  public void start() { go = true; (new Thread(new MyRun())).start(); }
  public void stop() { go = false; }
  class MyRun implements Runnable {
    public void run() {
      time = 0.001 * System.currentTimeMillis();
      while(go) {
        try { Thread.sleep(100); } catch(Exception e) { }
        double dt = 0.001 * System.currentTimeMillis() - time;
        for(int i = 0; i < 10; ++i) A[i].addTime(dt);
        time += dt; repaint();
      }
    }
  }

  interface Animation {
    public void addTime(double dt);
    public void draw(Graphics g);
  }
  static class FallingCircle implements Animation {
    Color col;
    double t = 0, gx, gy, rad, amp, pha, x0, y0;
    public FallingCircle(Color c, double x, double y,
                         double r, double a, double p) {
      col = c; gx = x; gy = y; rad = r; amp = a; pha = p; x0 = x; y0 = y;
    }
    public void addTime(double dt) {
      t += dt;
      gx = x0 + amp*Math.sin(t + pha); gy = y0 + 10*t;
      if(gy > 300 + rad) { y0 = -rad; pha += t; t = 0; }
    }
    public void draw(Graphics g) {
      g.setColor(col);
      g.fillOval((int)(gx-rad), (int)(gy-rad), (int)rad*2, (int)rad*2);
    }
  }
}
