import java.applet.Applet;
import java.awt.*;

public class Mima extends Applet{
    Image offimage;
    Graphics offgraphics;
    public void update(Graphics g) {
	int w = getSize().width, h = getSize().height;
	if(offimage == null){
	    offimage = createImage(w, h);
	    offgraphics = offimage.getGraphics();
	}
	offgraphics.setColor(getBackground());
	offgraphics.fillRect(0, 0, w, h);
	paint(offgraphics);
	g.drawImage(offimage, 0, 0, this);
    }
    boolean go;
    double time;
    Animation[] a=new Animation[20];
    int count=0;
    public void init(){
	a[count++]=new Boundball(Color.red,20,20,20,20,30,0);
    }
    public void paint(Graphics g){
	for(int i=0; i<count; ++i)a[i].draw(g);
    }
    public void start(){go=true; (new Thread(new MyRun())).start();}
    public void stop(){go=false;}
    class MyRun implements Runnable{
	public void run(){
	    time=0.001*System.currentTimeMillis();
	    while(go){
		try{Thread.sleep(100);}catch(Exception e){ }
		double dt=0.001*System.currentTimeMillis()-time;
		for(int i=0; i<count; ++i)a[i].addTime(dt);
		time+=dt; repaint();
	    }
	}
    }
    interface Animation{
	public void addTime(double dt);
	public void draw(Graphics g);
    }
    static class Boundball implements Animation{
	Color col;
	double gx, gy, a, b, vx, vy;
	public Boundball(Color c, double x, double y, double m, double n, double vx1, double vy1){
	    col=c; gx=x; gy=y; a=m; b=n; vx=vx1; vy=vy1;
	}
	public void addTime(double dt){
	    gx+=vx*dt; gy+=vy*dt; vy+=40*dt; a+=9*dt; b+=9*dt;
	    if(gx<20 && vx<0 || gx>280 && vx>0){vx=-vx*0.8; a=10;}
	    if(gy>180 && vy>0){vy=-vy*0.7; b=10;}
	    if(gy<20 && vy>0)vy=-vy;
	    if(a>=20)a=20;
	    if(b>=20)b=20;
	    }
	public void draw(Graphics g){
	    g.setColor(col);
	    g.fillOval((int)(gx-a),(int)(gy-b),(int)a*2,(int)b*2);
	}			
    }
}