import java.applet.Applet;
import java.awt.*;

public class R7Sample4 extends Applet{
    Image offimage;
    Graphics offgraphics;

    boolean go;
    double time;
    Animation[] a = new Animation[20];
    int count = 0;

    public void init(){
	for(int i= 0; i < 5; i++){
	    a[count++] = new Star(Color.red, 150, 100, 2*Math.random(), 6 + 6*Math.random());
	    a[count++] = new Star(Color.blue, 150, 100, 2*Math.random(), 6 + 6*Math.random());
	    a[count++] = new Star(Color.green, 150, 100, 2*Math.random(), 6 + 6*Math.random());
	    a[count++] = new Star(Color.yellow, 150, 100, 2*Math.random(), 6 + 6*Math.random());
	}
    }

    public void paint(Graphics g){
	for(int i = 0; i < count; i++)a[i].draw(g);
    }

    public void update(Graphics g){
	int w = getSize().width, h = getSize().height;
	if(offimage == null){
	    offimage = createImage(w, h);
	    offgraphics = offimage.getGraphics();
	}
	//offgraphics.setColor(getBackground());
	offgraphics.setColor(Color.black);
	offgraphics.fillRect(0, 0, w, h);
	paint(offgraphics);
	g.drawImage(offimage, 0, 0, this);	
    }

    public void start(){ go = true; (new Thread(new MyRun())).start();}
    public void stop(){ go = false;}

    class MyRun implements Runnable{
	public void run(){
	    time = 0.001 * System.currentTimeMillis();
	    while(go){
		try{ Thread.sleep(100);} catch(Exception e){}
		double dt = 0.001 * System.currentTimeMillis() - time;
		for(int i = 0; i < count; i++)a[i].addTime(dt);
		time += dt;
		repaint();
	    }
	}
    }

    interface Animation{
	public void addTime(double dt);
	public void draw(Graphics g);
    }

    static class Star implements Animation{
	Color col, dcol;
	double gx, gy, rad, tim, stime;
	double dgx, dgy;
	int[] sx = new int[5];
	int[] sy = new int[5];
	double[] st = new double[5];

	public Star(Color c, double x, double y, double r, double t){
	    col = c; gx = x; gy = y; rad = r; tim = t;
	    dcol = c; //
	    dgx = x;  //default value
	    dgy = y;  //
	    stime = 0;
	    st[0] = 1.1;
	    st[1] = 1.9;
	    st[2] = 0.7;
	    st[3] = 1.5;
	    st[4] = 0.3;
	}

	public void addTime(double dt){
	    stime += dt;
	    if(stime < 6){
		gx += dt * 15 * Math.cos(rad * Math.PI);
		gy += dt * 15 * Math.sin(rad * Math.PI);
		for(int i = 0; i < 5; i++){
		    sx[i] = (int)(gx + 10 * Math.cos(Math.PI * st[i]));
		    sy[i] = (int)(gy + 10 * Math.sin(Math.PI * st[i]));
		}
	    }else if(stime < tim) {
		//kuru kuru
		for(int i = 0; i < 5; i++){
		    sx[i] = (int)(gx + 10 * Math.cos(Math.PI * (st[i]+0.4*stime) ));
		    sy[i] = (int)(gy + 10 * Math.sin(Math.PI * (st[i]+0.4*stime) ));
		}
	    }else if(stime < tim + 2){
		//pika
		for(int i = 0; i < 5; i++){
		    sx[i] = (int)(gx + (10 + 5*(stime-tim)) * Math.cos(Math.PI *(st[i]+0.4*tim) ));
		    sy[i] = (int)(gy + (10 + 5*(stime-tim)) * Math.sin(Math.PI *(st[i]+0.4*tim) ));
		}
		if(stime > tim + 1)col = col.darker();
	    }else{
		stime = 0;
		col = dcol;
		gx = dgx;
		gy = dgy;
	    }
	}
	
	public void draw(Graphics g){
	    g.setColor(col);
	    g.fillPolygon( sx, sy, 5);
	}
    }
}