import java.applet.Applet;
import java.awt.*;

public class R7Sample43 extends Applet {
    Cylinder c1 = new Cylinder(Color.darkGray, Color.gray, 150, 370, 5);
    Fuse f1 = new Fuse(155, 380, 61);
    Spark s1 = new Spark(215, 380, 4);
    Circle c2 = new Circle(Color.gray, 150, 360, 2);
    Flame fl1 = new Flame(255, 150, 0, 0, 1.58, 200);
    Flame fl2 = new Flame(255, 255, 0, 0, 1.56, 150);
    Flame fl3 = new Flame(0, 255, 0, 0, 1.4, 100);
    Flame fl4 = new Flame(255, 0, 0, 0, 1.6, 250);

Image offimage;
    Graphics offgraphics;
    public void update(Graphics g) {
	int w = getSize().width, h = getSize().height;
	if(offimage == null) {
	    offimage = createImage(w, h);
	    offgraphics = offimage.getGraphics();
	}
	offgraphics.setColor(getBackground());
	offgraphics.fillRect(0, 0, w, h);
	paint(offgraphics);
	g.drawImage(offimage, 0, 0, this);
    }

    public void paint(Graphics g) {
	g.setColor(new Color(0, 0,  0));
	g.fillRect(0, 0, 300, 350);
	g.setColor(new Color(160, 80, 20));
	g.fillRect(0, 350, 300, 50);
c1.draw(g);f1.draw(g);s1.draw(g);c2.draw(g);fl1.draw(g);fl2.draw(g);fl3.draw(g);fl4.draw(g);
    }
    public void start() { (new Thread(new Ignition())).start(); }
    class Ignition implements Runnable {
	public void run() {
	    for(int i = 0; i < 60; ++i) {
		try { Thread.sleep(40); } catch(Exception e) {}
		f1.burning(f1.getI()-1);
		s1.burning(s1.getX()-1);
		repaint();
	    }

	    s1.vanishing();
	    for(int i = 0; i < 30; ++i) {
		try { Thread.sleep(30); } catch(Exception e) {}
		c2.rising(c2.getY()-8);
		repaint();
	    }
	    for(int i = 0; i < 11; ++i) {
		try { Thread.sleep(50); } catch(Exception e) {}
		fl1.nobi(fl1.getL()+1/(i*i+1));
		fl2.nobi(fl2.getL()+1/(i*i+1));
		fl3.nobi(fl3.getL()+1/(i*i+1));
		fl4.nobi(fl4.getL()+1/(i*i+1));
		repaint();
	    }
	    for(int i = 0; i < 20; ++i) {
		try { Thread.sleep(100); } catch(Exception e) {}

fl1.yoin((int)(fl1.getA()*8/9),(int)(fl1.getB()*8/9),(int)(fl1.getC()*8/9));

fl2.yoin((int)(fl2.getA()*8/9),(int)(fl2.getB()*8/9),(int)(fl2.getC()*8/9));

fl3.yoin((int)(fl3.getA()*8/9),(int)(fl3.getB()*8/9),(int)(fl3.getC()*8/9));

fl4.yoin((int)(fl4.getA()*8/9),(int)(fl4.getB()*8/9),(int)(fl4.getC()*8/9));
		repaint();
	    }
	}
    }
    static class Fuse {
	int[] fusex = new int[61];
	int[] fusey = new int[61];
	int count;
	public Fuse(int x, int y, int c) {
	    count = c;
	    for(int i = 0; i <= 60; ++i) {
		fusex[i] = x+i;
		fusey[i] = y+(int)(5*Math.sin(Math.PI/15*i));
	    }
	}
	public void draw(Graphics g) {
	    g.setColor(Color.black);
	    g.drawPolyline(fusex, fusey, count);
	}
	public void burning(int i) { count = i;}
	int getI() {return count;}
    }
    static class Spark {
	int cx, cy, size ,count = 0;
	int[] posx = new int[25];
	int[] posy = new int[25];
	public Spark(int x, int y, int s) {
	    cx = x; cy = y; size = s;
	    for(int i = 0; i <= 11; ++i) {
		posx[2*i] = (int)(cx+2*size*Math.sin(Math.PI/6*i));
		posy[2*i] = (int)(cy-2*size*Math.cos(Math.PI/6*i));
		posx[2*i+1] = (int)(cx+size*Math.sin(Math.PI/12*(2*i+1)));
		posy[2*i+1] = (int)(cy-size*Math.cos(Math.PI/12*(2*i+1)));
	    }
	    posx[24] = posx[0]; posy[24] = posy[0];
	}
	public void draw(Graphics g) {
	    if(count%2 == 0) {
		g.setColor(Color.red);
	    } else {
		g.setColor(Color.orange);
	    }
	    g.fillPolygon(posx, posy, 25);
	}
	public void burning(int x) {
	    cx = x;
	    for(int i = 0; i <= 11; ++i) {
		posx[2*i] = (int)(cx+2*size*Math.sin(Math.PI/6*i));
		posy[2*i] =
(int)(cy-2*size*Math.cos(Math.PI/6*i))+(int)(5*Math.sin(Math.PI/15*(cx-155)));
		posx[2*i+1] = (int)(cx+size*Math.sin(Math.PI/12*(2*i+1)));
		posy[2*i+1] =
(int)(cy-size*Math.cos(Math.PI/12*(2*i+1)))+(int)(5*Math.sin(Math.PI/15*(cx-155)));
	    }
	    posx[24] = posx[0]; posy[24] = posy[0]; ++count;
	}
	int getX() {return cx;}
	public void vanishing() {
	    for(int i = 0; i <= 24; ++i) {posx[i] = posy[i] = 0;}
	}
    }
    static class Circle {
	Color col;
	double gx, gy, rad;
	public Circle(Color c, double x, double y, double r) {
	    col = c; gx = x; gy = y; rad = r;
	}
	public void draw(Graphics g) {
	    g.setColor(col);
	    g.fillOval((int)(gx-rad),(int)(gy-rad),(int)rad*2,(int)rad*2);
	}
	public void rising(double y) { gy = y; }
	double getY() { return gy; }
    }
    static class Flame {
	int[] posx = new int[1000];
	int[] posy = new int[1000];
	Color col;
	double length, random, rate; int honsuu, red, green, blue;
	public Flame(int a, int b, int c, double l, double r, int h) {
	    red = a; green = b; blue = c; length = l; rate = r; honsuu = h;
	    col = new Color(red, green, blue);
	    for(int i = 0; i < honsuu*2; ++i) {
		posx[i] = posy[i] = 0;
	    }
	}
	public void draw(Graphics g) {
	    g.setColor(col);
	    g.drawPolyline(posx, posy, honsuu);
	}
	public void nobi(double l) {
	    length = rate*l;
	    for(int i = 0; i < honsuu*2; ++i) {
		random = Math.random()-0.5;
		posx[2*i] = (int)(150+l*Math.cos(Math.PI*random*2));
		posy[2*i] = (int)(130+l*Math.sin(Math.PI*random*2));
		posx[2*i+1] = 150;
		posy[2*i+1] = 130;
	    }
	}
	double getL() { return length; }
	public void yoin(int a, int b,  int c) {
	    red = a; green = b; blue = c;
	    col = new Color(a, b, c);
	}
	double getA() { return red; }
	double getB() { return green; }
	double getC() { return blue; }
    }
}

class Cylinder {
    Color col1, col2;
    double pillarx, pillary, ovalx1, ovaly1, ovalx2, ovaly2, size;
    public Cylinder(Color c1, Color c2, double x, double y, double s) {
	col1 = c1; col2 = c2; size = s;
	pillarx = ovalx1 = ovalx2 = x-s; pillary = y-2*s; ovaly1 = y-2.5*s;ovaly2= y+1.5*s;}
    public void draw(Graphics g) {
	g.setColor(col1);
	g.fillRect((int)pillarx,(int)pillary,(int)size*2,(int)size*4);
	g.fillOval((int)ovalx2,(int)ovaly2,(int)size*2,(int)size);
	g.setColor(col2);
	g.fillOval((int)ovalx1,(int)ovaly1,(int)size*2,(int)size);
    }
}