import java.applet.Applet;
import java.awt.*;

public class R7ex4 extends Applet {
  boolean go;
  double time;
  static Animation[] a = new Animation[20];
  static int count = 0;
  static boolean[] hit = new boolean[20];
  static int j;
  Image offimage;
  Graphics offgraphics;
  public void init() {
    a[count++] = new HomingCircle(Color.red, 0, 150, 5, 10);
    a[count++] = new FlyingObject(250, 100, 15, 30, 0);
    a[count++] = new FlyingObject(150,  50, 10, 30, 3);
    a[count++] = new FlyingObject(200,  70, 20, 30, 5);
  }
  public void paint(Graphics g) {
    for(int i = 0; i< count; ++i) {
      a[i].draw(g);
      hit[i] = false;
    }
  }
  public void start() { go = true; (new Thread(new MyRun())).start(); }
  public void stop() { go = false; }
  public void update(Graphics g) {
    int w = getSize().width, h = getSize().height;
    if(offimage == null) {
      offimage = createImage(w, h);
      offgraphics = offimage.getGraphics();
    }
    offgraphics.setColor(getBackground());
    offgraphics.fillRect(0, 0, w, h);
    paint(offgraphics);
    g.drawImage(offimage, 0, 0, this);
  }
  class MyRun implements Runnable {
    public void run() {
      time = 0.001 * System.currentTimeMillis();
      while(go) {
        try{ Thread.sleep(100); } catch(Exception e) { }
        double dt = 0.001 * System.currentTimeMillis() - time;
        for(j = 0; j < count; ++j) a[j].addTime(dt);
        time += dt; repaint();
      }
    }
  }
  interface Animation {
    public void addTime(double dt);
    public void draw(Graphics g);
    public double getX();
    public double getY();
    public double getV();
    public double getD();
    public double getR();
  }
  static class HomingCircle implements Animation {
    Color col;
    double gx, gy, rad, vel, deg, deg1;
    boolean flag = false;
    int t = 1;
    public HomingCircle(Color c, double x, double y, double r, double v) {
      col = c; gx = x; gy = y; rad = r; vel = v; deg = 0;
    }
    public void addTime(double dt) {
      if(flag) {
        for(int i = 1; i < count; ++i) {
	  if(Math.pow(a[t].getX()-gx,2)+Math.pow(a[t].getY()-gy,2) >
	      Math.pow(a[i].getX()-gx,2)+Math.pow(a[i].getY()-gy,2)) { t = i;}
        }
      flag = false;
      }
      deg1 = ( Math.atan2(a[t].getY() - gy, a[t].getX() - gx)
                 - deg + Math.PI * 4) % (Math.PI * 2);
      if(deg1 > Math.PI) { deg1 -= Math.PI * 2; }
      if(deg1 > 0) { deg += Math.PI * dt; }
              else { deg -= Math.PI * dt;}
      if(deg < 0) deg += Math.PI * 2;
      if(deg > Math.PI * 2) deg -= Math.PI * 2;
      vel += 10*(Math.PI / 6 - Math.abs(deg1));
      if(vel < 10) vel = 10;
      gx += vel*Math.cos(deg)*dt; gy += vel*Math.sin(deg)*dt;
      for(int i = 1; i < count; ++i) {
        if(Math.pow(a[i].getX()-gx,2)+Math.pow(a[i].getY()-gy,2)
            <= Math.pow(a[i].getR(),2) + rad*rad) {
	  hit[i] = true; flag = true;
        }
      }
    }
    public void draw(Graphics g) {
      g.setColor(col);
      g.fillOval((int)(gx-rad),(int)(gy-rad),(int)rad*2,(int)rad*2);
    }
    public double getX() { return gx; }
    public double getY() { return gy; }
    public double getV() { return vel; }
    public double getD() { return deg; }
    public double getR() { return rad; }
  }
  static class FlyingObject implements Animation {
    double gx, gy, rad, vel, deg;
    int ccount = 17 * (int)(Math.random()*13 + 1); int cflag = 17;
    int[] x = new int[12];
    int[] y = new int[12];
    public FlyingObject(double x, double y, double r, double v, double d) {
      gx = x; gy = y; rad = r; vel = v; deg = d;
    }
    public void addTime(double dt) {
      if(hit[j]) {
        gx = 300*Math.random(); gy = 200*Math.random(); hit[j] = false;
      }
      deg += (Math.random()-0.5);
      gx += vel * Math.cos(deg) * dt;
      gy += vel * Math.sin(deg) * dt;
      if(gx < rad) { gx = rad; deg = Math.PI - deg; }
      if(gy < rad) { gy = rad; deg = -deg; }
      if(gx > 300 - rad) { gx = 300 - rad; deg = Math.PI - deg; }
      if(gy > 200 - rad) { gy = 200 - rad; deg = -deg; }
      ccount += cflag;
      if(ccount == 0 || ccount == 255) cflag = -cflag;
      for(int i = 0; i < 12; ++i) {
	x[i] = (int)(rad * Math.cos(deg + Math.PI * i / 6));
	y[i] = (int)(rad * Math.sin(deg + Math.PI * i / 6));
        if(i % 2 == 1) {
          x[i] = (int)(x[i] * (ccount + 45) / 300);
          y[i] = (int)(y[i] * (ccount + 45) / 300);
	}
      x[i] += gx; y[i] += gy;
      }
    }
    public void draw(Graphics g) {
      g.setColor(new Color(0, ccount, 255-ccount));
      g.fillPolygon(x, y, 12);
    }
    public double getX() { return gx; }
    public double getY() { return gy; }
    public double getV() { return vel; }
    public double getD() { return deg; }
    public double getR() { return rad; }
  }
}
