import java.applet.Applet;
import java.awt.*;
import java .awt.event.*;

public class R8Sample2 extends Applet {
  static final int xmin = 50, xmax = 300, ymin = 50, ymax = 200;
  double time = 0.0;
  boolean running = false;
  Circle s1 = new Circle(Color.blue, 100, 100, 20, 23, 35);
  Circle s2 = new Circle(Color.red, 120, 80, 30, -40, 25);

  public void paint(Graphics g) { s2.draw(g); s1.draw(g); }
  public void start() {
    if(!running) { (new Thread(new MyRun())).start(); running = true; }
  }
  public void stop() {running = false; }

  class MyRun implements Runnable {
    public void run() {
      long t0 = System.currentTimeMillis();
      while(running) {
	try { Thread.sleep(100); } catch(Exception ex) { }
	long t1 = System.currentTimeMillis();
	double dt = 0.001*(t1 - t0);
	time += 0.001*(t1 - t0); t0 =t1;
	s1.addTime(dt); s2.addTime(dt); time += dt; repaint();
      }
    }
  }
  static class Circle {
    Color col; // F
    double gx, gy, rad, vx, vy; //dSXAYWAaAx

    public Circle(Color c, double x, double y, double r,
		  double vx0, double vy0) {
      gx = x; gy = y; rad = r; col = c; vx = vx0; vy = vy0;
    }
    public void  draw(Graphics g) {
      int len = (int)(rad*2);
      g.setColor(col); g.fillOval((int)(gx-rad), (int)(gy-rad), len, len);
    }
    public void addTime(double dt) {
      double a = 0.999; double b = 0.999;
      vx = vx*a; vy = vy*b;
      gx = gx + vx*dt; gy = gy + vy*dt;
      if(vx < 0 && gx < xmin) vx = -vx;
      if(vx > 0 && gx > xmax) vx = -vx;
      if(vy < 0 && gy < xmin) vy = -vy;
      if(vy > 0 && gy > xmax) vy = -vy;
    }
  }
}
