
import java.applet.Applet;
import java.awt.*;
import java .awt.event.*;

public class R8Sample2h extends Applet {
  static final int xmin = 10, xmax = 590, ymin = 10, ymax = 480;
  double time = 0.0;
  boolean running = false;
  Sankaku s1 = new Sankaku(Color.green, 80.0, 100.0, 200.0, 100.0,
			   110.0,190.0, 20, 40, 1.4);
  Sankaku s2 = new Sankaku(Color.cyan, 200.0, 180.0, 180.0, 240.0,
			   300.0, 380.0, 30, 30, 0.3);
  Sankaku s3 = new Sankaku(Color.red, 280.0, 280.0, 320.0, 330.0,
			   290.0, 360.0, 70, 50, 1.8);

  public void paint(Graphics g) { s3.draw(g); s2.draw(g); s1.draw(g); }
  public void start() {
    if(!running) { (new Thread(new MyRun())).start(); running = true; }
  }
  public void stop() {running = false; }

  class MyRun implements Runnable {
    public void run() {
      long t0 = System.currentTimeMillis();
      while(running) {
	try { Thread.sleep(100); } catch(Exception ex) { }
	long t1 = System.currentTimeMillis();
	double dt = 0.001*(t1 - t0);
	time += 0.001*(t1 - t0); t0 =t1;
	s1.addTime(dt); s2.addTime(dt); s3.addTime(dt); time += dt; repaint();
      }
    }
  }
  static class Sankaku {
    Color col;
    double gx, gy, vx, vy;
    double[] len = new double[3];
    double[]theta = new double[3];
    double t0, vt;
    int[] xpos = new int[3];
    int[] ypos = new int[3];

    public Sankaku(Color c, double x0, double y0, double x1, double y1,
		   double x2, double y2,double vx0, double vy0, double vt0) {
      gx =(x0+x1+x2)/3.0 ; gy =(y0+y1+y2)/3.0 ;  col = c;
      vx = vx0; vy = vy0; vt = vt0;
      len[0] = Math.sqrt((x0-gx)*(x0-gx) + (y0-gy)*(y0-gy));
      len[1] = Math.sqrt((x1-gx)*(x1-gx) + (y1-gy)*(y1-gy));
      len[2] = Math.sqrt((x2-gx)*(x2-gx) + (y2-gy)*(y2-gy));
      theta[0] = Math.atan2(y0-gy, x0-gx);
      theta[1] = Math.atan2(y1-gy, x1-gx);
      theta[2] = Math.atan2(y2-gy, x2-gx);
      t0 = 0.0;
    }
    public void draw(Graphics g) {
      for(int i = 0; i < 3; ++i) {
	xpos[i] = (int)(gx + len[i] * Math.cos(t0 + theta[i]));
	ypos[i] = (int)(gy + len[i] * Math.sin(t0 + theta[i]));
      }
      g.setColor(col); g.fillPolygon(xpos, ypos, 3);
    }

    public void addTime(double dt) {
      gx = gx + vx*dt; gy = gy + vy*dt;
      for(int i = 0; i < 3; ++i) {
	theta[i] = theta[i] + vt*dt;
        if(vx < 0 && gx+len[i]*Math.cos(t0+theta[i]) < xmin) vx = -vx;
	if(vx > 0 && gx+len[i]*Math.cos(t0+theta[i]) > xmax) vx = -vx;
	if(vy < 0 && gy+len[i]*Math.sin(t0+theta[i]) < ymin) vy = -vy;
	if(vy > 0 && gy+len[i]*Math.sin(t0+theta[i]) > ymax) vy = -vy;
      }
    }
  }
}

