
  import java.applet.*;
  import java.awt.*;
  import java.awt.event.*;

  public class R9Sample1 extends Applet {
    Choice c1 = new Choice();
    Animation[] a = new Animation[100];
    int count = 0;
    boolean running = false;

    public void init() {
      setLayout(null);
      add(c1); c1.setBounds(10, 10, 80, 30);
      c1.add("MovingString"); c1.add("ResizingCircle");
      c1.add("ResizingNStar"); c1.add("ResizingSquare");
      addMouseListener(new MouseAdapter() {
        public void mousePressed(MouseEvent evt) {
          if(count < a.length) {
            a[count] = makeAnimation(c1.getSelectedIndex(),
                                     evt.getX(), evt.getY()); ++count;
          }
        }
      });
    }
    public void start() {
      if(running) return;
      running = true;
      (new Thread(new Runnable() {
        public void run() {
          long t0 = System.currentTimeMillis();
          while(running) {
            try { Thread.sleep(100); } catch(Exception ex) { }
            long t1 = System.currentTimeMillis();
            double dt = 0.001*(t1 - t0); t0 = t1;
            for(int i = 0; i < count; ++i) a[i].addTime(dt);
            repaint();
          }
        }
      })).start();
    }
    public void stop() { running = false; }
    public void paint(Graphics g) {
      for(int i = 0; i < count; ++i) a[i].draw(g);
    }
    Animation makeAnimation(int i, int x, int y) {
      if(i == 0) {
        return  new MovingString(
          new Font("Serif", Font.BOLD, 8+(int)(20*Math.random())),
          new Color((int)(255*Math.random()),
                    (int)(255*Math.random()), (int)(255*Math.random())),
          "Hello!",
          x-30*Math.random(), y-30*Math.random(),
          x+30*Math.random(), y-30*Math.random(),
          1+3*Math.random());
      } else if(i == 1) {
        return new ResizingCircle(
          new Color((int)(255*Math.random()),
                    (int)(255*Math.random()), (int)(255*Math.random())),
          x, y,
          10+20*Math.random(), 15+50*Math.random(), 5*Math.random());
      } else if(i == 2) {
        return new RotatingNStar(
          3+(int)(5*Math.random()),
          new Color((int)(255*Math.random()), (int)(255*Math.random()),
                    (int)(255*Math.random())),
          x, y,
          10+100*Math.random(), 5+50*Math.random(), 3*Math.random());
      } else {
        return new ResizingSquare(
          new Color((int)(255*Math.random()),
                    (int)(255*Math.random()), (int)(255*Math.random())),
          x, y,
          10+100*Math.random(), 5+50*Math.random(), 3*Math.random());
      }
    }
    interface Animation {
      public void draw(Graphics g);
      public void addTime(double dt);
    }
    class MovingString implements Animation {
      Font fn;
      Color col;
      String str;
      double gx, gy, lx, ly, time, freq;
      public MovingString(Font f, Color c, String s,
               double x0, double y0, double x1, double y1, double fr) {
        fn = f; col = c; str = s; gx = x0; gy = y0; lx = x1-x0; ly = y1-y0;
        time = 0.0; freq = fr;
      }
      public void draw(Graphics g) {
        double r = (time % freq) / freq;
        g.setFont(fn); g.setColor(col);
        g.drawString(str, (int)(gx + lx*r), (int)(gy + ly*r));
      }
      public void addTime(double dt) { time = time + dt; }
    }
    class ResizingCircle implements Animation {
      Color col;
      double gx, gy, rad, amp, theta, vtheta;
      public ResizingCircle(Color c, double x, double y,
               double r0, double r1, double vt) {
        col = c; gx = x; gy = y; rad = (r0+r1)/2; amp = (r1-r0)/2;
        theta = 0.0; vtheta = vt;
      }
      public void draw(Graphics g) {
        double r = rad + amp*Math.sin(theta);
        g.setColor(col);
        g.fillOval((int)(gx-r), (int)(gy-r), (int)(2*r), (int)(2*r));
      }
      public void addTime(double dt) { theta = theta + vtheta * dt; }
    }
    class RotatingNStar implements Animation {
      int num;
      int[] xpos;
      int[] ypos;
      Color col;
      double gx, gy, len0, len1, theta, vtheta;
      public RotatingNStar(int n, Color c, double x, double y,
               double l0, double l1, double vt) {
        num = n; xpos = new int[2*n]; ypos = new int[2*n]; col = c;
        gx = x; gy = y; len0 = l0; len1 = l1; theta = 0.0; vtheta = vt;
      }
      public void draw(Graphics g) {
        for(int i = 0; i < 2*num; ++i) {
          double l = len0; if(i%2 == 1) l = len1;
          xpos[i] = (int)(gx + l*Math.cos(theta + Math.PI/num*i));
          ypos[i] = (int)(gy + l*Math.sin(theta + Math.PI/num*i));
        }
        g.setColor(col); g.fillPolygon(xpos, ypos, 2*num);
      }
      public void addTime(double dt) { theta = theta + vtheta * dt; }
    }
    class ResizingSquare implements Animation {
      Color col;
      double gx, gy, len, amp, theta, vtheta;
      public ResizingSquare(Color c, double x, double y, double l0,
                            double l1, double vt) {
	col = c; gx = x; gy = y; len = (l0+l1)/2; amp = (l1-l0)/2;
        theta = 0.0;  vtheta = vt;
      }
      public void draw(Graphics g) {
        double l = len + amp*Math.sin(theta);
        g.setColor(col);
        g.fillRect((int)(gx-l), (int)(gy-l), (int)(2*l), (int)(2*l));
      }
      public void addTime(double dt) { theta = theta + vtheta * dt; }
    }
  }
