import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;

public class R9ex4 extends Applet{

   int score = 0;
   int count = 0;
   Animation a[] = new Animation[20];
   Button b1 = new Button("start");
   Button b2 = new Button("bomb");
   MyPanel body = new MyPanel();

   public void init(){
      setLayout(null);
      add(b1);b1.setBounds(80,15,40,25);add(b2);b2.setBounds(160,15,40,25);
      add(body);body.setBounds(50,60,200,300);

      b1.addActionListener(new ActionListener(){
         public void actionPerformed(ActionEvent evt){
            body.start();
         }
      });

      b2.addActionListener(new ActionListener(){
         public void actionPerformed(ActionEvent evt){
            a[count] = new Sphere(100,0,25);++count;
         }
      });

   }

   public void paint(Graphics g){
      g.drawRect(49,59,202,302);
   }

   class MyPanel extends Panel{
      boolean go;
      double time;

      public MyPanel(){
         addMouseListener(new MouseAdapter(){
            public void mousePressed(MouseEvent e){
               for(int i = 0;i<count ;++i){
                  a[i].touched(e.getX(),e.getY());
               }
            }
         });
      }

      public void start(){
         score = 0;
         count = 0;
         (new Thread(new Runnable(){
            public void run(){
               double time = 0.001*System.currentTimeMillis();
               go = true;
               while(go){
                  try{Thread.sleep(50);}catch(Exception e){}
                  double dt = 0.001*System.currentTimeMillis() - time;
                  for(int i = 0;i<count && go == true;++i){
                     go = a[i].addTime(dt);
                     score += (int)200*dt;
                  }
                  time += dt;
                  ;
                  repaint();
               }
               repaint();

             }
         })).start();
       }

      public void stop(){go = false; }
      public void paint(Graphics g){
         for(int i = 0;i<count;++i)a[i].draw(g);
         g.drawString("Score:"+score,1,10);
         if(go == false){g.drawString("Game Over",65,150);};
      }

   }

   interface Animation{
      public void draw(Graphics g);
      public boolean addTime(double dt);
      public void touched(double x,double y);
   }

   static class Sphere implements Animation{
      double vx = 0 ,vy = 0,r;
      double gx = 0,gy = 0,g = 98;

      public Sphere(int x,int y,int fr){
         gx = x;gy = y;r = fr;
      }

      public boolean addTime(double dt){
         if(gy >= 300+r ){
            return false;
         }else{
            if(gx <= r ){vx = - vx;gx = r + 0.001;}
            if(gx >= 200-r){vx = -vx;gx = 200 - r - 0.001;}
            gx += vx*dt;
            gy += vy*dt + g*dt*dt/2;
            vy = vy + g*dt;
            return true;
         }
      }

      public void touched(double mx,double my){
         if(((mx-gx)*(mx-gx) + (my-gy)*(my-gy)) <= r*r ){
            vy -= 200;
            if((my-gy)<0){vx = vx + (mx - gx)*2.0;}
            else{vx = vx -(mx - gx)*2.0;}
         }
      }

      public void draw(Graphics g){
         g.drawOval((int)(gx-r), (int)(gy-r), (int)r*2, (int)r*2);
      }

   }

}
