import java.applet.*;
import java.awt.*;

public class Report0904d extends Applet {
    Animation[] a;
    boolean running = false;

    public void init() {
        a = new Animation[]{
            new StillCircle(200, 150, 20, Color.yellow),
            new ResizeCircle(100, 80, 10, 50, Color.green),
            new MovingCircle(150, 90, 20, 70, 50, Color.red),
            new ColorCircle(230, 120, 15, 60, 80),
            new ResizeSquare(50, 100, 40, 80, Color.blue),
            new MovingSquare(125, 130, 10, 100, 100, Color.magenta),
            new ChangingFigure(175, 170, 30, 90, 70, Color.cyan),
            new MovingOval(75, 200, 50, 30, Color.white)
        };
    }
    public void start() {
        if(running) {
            return;
        }
        running = true;
        (new Thread(new Runnable() {
            public void run() {
                long t0 = System.currentTimeMillis();
                while(running) {
                    try {
                        Thread.sleep(100);
                    } catch(Exception ex) { }
                    long t1 = System.currentTimeMillis();
                    double dt = 0.001 * (t1 - t0);
                    t0 = t1;
                    for(int i = 0; i < a.length; ++i) {
                        a[i].addTime(dt);
                    }
                    repaint();
                }
            }
        })).start();
    }
    public void stop() {
        running = false;
    }
    public void paint(Graphics g) {
        for(int i = 0; i < a.length; ++i) {
            a[i].draw(g);
        }
    }

    interface Animation {
        public void draw(Graphics g);
        public void addTime(double dt);
    }

    class StillCircle implements Animation {
        Color col;
        double time;
        double xpos, ypos, rad;
        public StillCircle(double x, double y, double r, Color c) {
            xpos = x;
            ypos = y;
            rad = r;
            col = c;
        }
        public void draw(Graphics g) {
            g.setColor(col);
            g.fillOval((int)(xpos - rad), (int)(ypos - rad),
                       (int)(2 * rad), (int)(2 * rad));
        }
        public void addTime(double dt) {
            time = time + dt;
        }
    }
    class ResizeCircle extends StillCircle {
        double rad1, rad2;
        public ResizeCircle(double x, double y, double r1, double r2,
                            Color c) {
            super(x, y, r1, c);
            rad1 = r1;
            rad2 = r2;
        }
        public void addTime(double dt) {
            super.addTime(dt);
            rad = rad1 + 0.5 * (rad2 - rad1) * (Math.sin(time) + 1);
        }
    }
    class MovingCircle extends ResizeCircle {
        double x0, y0, rad3;
        public MovingCircle(double x, double y, double r1, double r2,
                            double r3, Color c) {
            super(x, y, r1, r2, c);
            x0 = x;
            y0 = y;
            rad3 = r3;
        }
        public void addTime(double dt) {
            super.addTime(dt);
            xpos = x0 + rad3 * Math.cos(time);
            ypos = y0 + rad3 * Math.sin(time);
        }
    }
    class ColorCircle extends MovingCircle {
        public ColorCircle(double x, double y,
                           double r1, double r2, double r3) {
            super(x, y, r1, r2, r3, Color.white);
        }
        public void addTime(double dt) {
            super.addTime(dt);
            col = Color.getHSBColor((float)(0.1 * time) % 1.0f, 0.5f, 0.5f);
        }
    }
    class ResizeSquare extends ResizeCircle {
        public ResizeSquare(double x, double y, double l1, double l2,
                            Color c) {
            super(x, y, l1, l2, c);
        }
        public void draw(Graphics g) {
            g.setColor(col);
            g.fillRect((int)(xpos - rad / 2.0), (int)(ypos - rad / 2.0),
                       (int)rad, (int)rad);
        }
    }
    class MovingSquare extends MovingCircle {
        public MovingSquare(double x, double y,
                            double l1, double l2, double r, Color c) {
            super(x, y, l1, l2, r, c);
        }
        public void draw(Graphics g) {
            g.setColor(col);
            g.fillRect((int)(xpos - rad / 2.0), (int)(ypos - rad / 2.0),
                       (int)rad, (int)rad);
        }
    }
    class ChangingFigure implements Animation {
        double time;
        MovingCircle mc;
        MovingSquare ms;
        public ChangingFigure(double x, double y,
                            double l1, double l2, double r, Color c){
            time = 0;
            mc = new MovingCircle(x, y, l1 / 2.0, l2 / 2.0, r, c);
            ms = new MovingSquare(x, y, l1, l2, r, c);
        }
        public void draw(Graphics g) {
            if((int)time % 2 == 0) {
                mc.draw(g);
            } else {
                ms.draw(g);
            }
        }
        public void addTime(double dt) {
            time = time + dt;
            mc.addTime(dt);
            ms.addTime(dt);
        }
    }
    class MovingOval extends MovingCircle {
        public MovingOval(double x, double y, double r,
                          double r3, Color c) {
            super(x, y, r, r, r3, c);
        }
        public void draw(Graphics g) {
            g.setColor(col);
            double xrad = rad * (1.0 + 0.5 * Math.cos(time));
            double yrad = rad * (1.0 + 0.5 * Math.sin(time));
            g.fillOval((int)(xpos - xrad), (int)(ypos - yrad),
                       (int)(2 * xrad), (int)(2 * yrad));
        }
    }
}
