import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class Report7B extends JApplet {

     Image buf;
     Ball[] balls;

     public void init() {
	balls = new Ball[16];
	for (int i = 0; i < balls.length; i++) {
	    balls[i] = new Ball(Math.random()*400, Math.random()*400, 2-i*0.1,
-i);
	}
	for (int i = 1; i < balls.length; i++) {
	    balls[i].setPointer(balls[i-1]);
	}
	MousePointer mp = new MousePointer();
	balls[0].setPointer(mp);
	addMouseMotionListener(mp);
     }

     public void paint(Graphics g) {
	for (int i = 0; i < balls.length; i++) {
	    balls[i].draw(g);
	}
     }

     public void update(Graphics g) {
	if (buf == null) {
	    buf = createImage(getWidth(), getHeight());
	}
	Graphics g2 = buf.getGraphics();
	g2.clearRect(0, 0, getWidth(), getHeight());
	paint(g2);
	
	g.drawImage(buf, 0, 0, this);
     }
     public void start() {
	(new Thread(new MyRun())).start();
     }
     class MyRun implements Runnable {
	public void run() {
	    while (true) {
		try {
		    Thread.sleep(50);
		} catch(Exception e) { }
		for (int i = 0; i < balls.length; i++) {
		    balls[i].move();
		}
		repaint();
	    }
	}
     }
     static interface Pointer {
	double getX();
	double getY();
     }

     static class Ball implements Pointer {
	double x;
	double y;
	double vx;
	double vy;
	double scale;
	int phi;

	Pointer pointer;

	public Ball(double x, double y, double scale, int phi) {
	    this.x = x;
	    this.y = y;
	    this.scale = scale;
	    this.phi = phi;
	}
	public void setPointer(Pointer pointer) {
	    this.pointer = pointer;
	}
	public void draw(Graphics g) {
	    double r = (Math.cos(phi*0.5)+4)*scale;
	    g.setColor(Color.black);
	    g.fillOval((int)(x-r), (int)(y-r), (int)(r*2), (int)(r*2));
	}
	public void move() {
	    double px = pointer.getX()-x;
	    double py = pointer.getY()-y;

	    double p = Math.sqrt(px*px+py*py);

	    x += vx;
	    y += vy;
	    vx += px/p;
	    vy += py/p;

	    double v = Math.sqrt(vx*vx+vy*vy);
	    vx /= v;
	    vy /= v;
	

	    phi++;
	}

	public double getX() {
	    return x;
	}
	public double getY() {
	    return y;
	}
     }
     static class MousePointer implements Pointer, MouseMotionListener {
	double x;
	double y;

	public double getX() {
	    return x;
	}
	public double getY() {
	    return y;
	}
	public void mouseMoved(MouseEvent e) {
	    x = e.getX();
	    y = e.getY();
	}
	public void mouseDragged(MouseEvent e) {
	    x = e.getX();
	    y = e.getY();
	}
     }
}
