import java.applet.Applet;
import java.awt.*;

public class Report7B8 extends Applet {
  boolean go;
  double time;
  int count = 0, w, h, balls = 12;
  Animation[] a = new Animation[balls];
  Image offimage;
  Graphics offgraphics;
  public void update(Graphics g) {
    if (offimage == null) {
      offimage = createImage(w, h);
      offgraphics = offimage.getGraphics();
    }
    offgraphics.setColor(getBackground());
    offgraphics.fillRect(0, 0, w, h);
    paint(offgraphics);
    g.drawImage(offimage, 0, 0, this);
  }
  public void init() {
    time = 0.0;
    String trance = "TRANCE";
    w = getSize().width; h = getSize().height;
    for (count = 0; count < balls; count += 2) {
      Color c = Color.getHSBColor(1.0f*count/balls, 1.0f, 1.0f);
      a[count] = new SmallCircle(c, 0.0, 50.0, 250.0, 0.0);
    }
    for (count = 1; count < balls; count += 2) {
      Color c = Color.getHSBColor(1.0f*count/balls, 1.0f, 1.0f);
      a[count] = new FlyingLetter("Serif", c, trance.charAt((count-1)/2), 0.0, 50.0, 250.0, 0.0);
    }
    count = balls;
  }
  public void paint(Graphics g) {
    g.setColor(Color.black);
    g.fillRect(0, 0, w, h);
    for (int i = 0; i < count; i++)
      a[i].draw(g);
  }
  public void start() {
    go = true;
    (new Thread(new MyRun())).start();
  }
  public void stop() {
    go = false;
  }
  class MyRun implements Runnable {
    int balls_now = 1;
    double sleepms = 0.05;
    public void run() {
      while (go) {
        try { Thread.sleep((int)(sleepms*1000)); } catch(Exception e) { }
        for (int i = 0; i < balls_now; i++)
          a[i].addTime(sleepms);
        if (balls_now < count)
          balls_now++;
        time += sleepms;
        repaint();
      }
    }
  }
  interface Animation {
    public void addTime(double dt);
    public void draw(Graphics g);
  }
  class FlyingLetter implements Animation {
    Color col;
    int srad = 8;
    float[] hsv = new float[3];
    double gx, gy, vx, vy, g = 1000, e = 0.97;
    Font fn;
    String letter;
    public FlyingLetter(String f, Color c, char l, double x, double y, double vx1, double vy1) {
      col = c; gx = x; gy = y; vx = vx1; vy = vy1; fn = new Font(f, Font.BOLD, srad*2); letter = String.valueOf(l);
      if (gx < srad)
        gx = srad;
      else if (gx > w-srad)
        gx = w-srad;
      if (gy < srad)
        gy = srad;
      else if (gy > h-srad)
        gy = h-srad;
      Color.RGBtoHSB(col.getRed(), col.getGreen(), col.getBlue(), hsv);
    }
    public void addTime(double dt) {
      vy += g*dt;
      gx += vx*dt;
      gy += vy*dt;
      if ((int)gy >= h-srad) {
        gy = (h-srad)-(dt-(gy-(h-srad))/vy)*vy*e;
        vy = -vy*e;
      }
      else if ((int)gy <= srad) {
        vy = -vy*e;
        gy = srad+(srad-gy);
      }
      if ((int)gx >= w-srad) {
        vx = -vx;
        gx = (w-srad)-(gx-(w-srad));
      }
      else if ((int)gx <= srad) {
        vx = -vx;
        gx = srad+(srad-gx);
      }
    }
    public void draw(Graphics g) {
      g.setFont(fn);
      g.setColor(col);
      g.drawString(letter, (int)gx, (int)gy);
    }
  }
  class SmallCircle implements Animation {
    Color col;
    int srad = 8;
    float[] hsv = new float[3];
    double gx, gy, vx, vy, g = 1000, e = 0.97;
    public SmallCircle(Color c, double x, double y, double vx1, double vy1) {
      col = c; gx = x; gy = y; vx = vx1; vy = vy1;
      if (gx < srad)
        gx = srad;
      else if (gx > w-srad)
        gx = w-srad;
      if (gy < srad)
        gy = srad;
      else if (gy > h-srad)
        gy = h-srad;
      Color.RGBtoHSB(col.getRed(), col.getGreen(), col.getBlue(), hsv);
    }
    public void addTime(double dt) {
      vy += g*dt;
      gx += vx*dt;
      gy += vy*dt;
      if ((int)gy >= h-srad) {
        gy = (h-srad)-(dt-(gy-(h-srad))/vy)*vy*e;
        vy = -vy*e;
      }
      else if ((int)gy <= srad) {
        vy = -vy*e;
        gy = srad+(srad-gy);
      }
      if ((int)gx >= w-srad) {
        vx = -vx;
        gx = (w-srad)-(gx-(w-srad));
      }
      else if ((int)gx <= srad) {
        vx = -vx;
        gx = srad+(srad-gx);
      }
    }
    public void draw(Graphics g) {
      for (int i = srad; i > 0; i--) {
        g.setColor(Color.getHSBColor(hsv[0], hsv[1], hsv[2]*(srad-i)/srad));
        g.fillOval((int)gx-i, (int)gy-i, i*2, i*2);
      }
    }
  }
}