import java.applet.Applet;
import java.awt.*;

public class Report7b3 extends Applet {
    boolean go;
    double time;
    Animation[] a = new Animation[20];
    int count = 0;
    Image offimage;
    Graphics offgraphics;
    public void init() {
	a[count++] = new FlyingCircle(Color.red, 100, 100, 30, 50, -30);
	a[count++] = new FlyingCircle(Color.red,  10, 100, 30, 90, -70);
	a[count++] = new FlyingCircle(Color.red, 100,  10, 20, 50,  90);
	a[count++] = new FlyingCircle(Color.red,  50,  30, 20, 50, -40);
	a[count++] = new FlyingCircle(Color.red, 200, 180, 20, -40, -60);
	a[count++] = new FlyingCircle(Color.red, 300, 100, 40, 15, -25);
	a[count++] = new FlyingCircle(Color.red,  60,  80, 15, 120, -80);
	a[count++] = new FlyingCircle(Color.red, 350, 280, 20, -60, -40);
	a[count++] = new ShootingStar(Color.yellow, 100, 20, 35, -30, 30);
	a[count++] = new ShootingStar(Color.yellow, 300, 70, 30, -20, 30);
	a[count++] = new ShootingStar(Color.yellow, 20, 10, 35, -40, 40);
	a[count++] = new ShootingStar(Color.yellow, 350, 180, 20, -20, 20);
	a[count++] = new ShootingStar(Color.yellow, 200, 50, 30, -30, 40);
    }
    public void paint(Graphics g) {
        g.setColor(new Color(10, 20, 50));
        g.fillRect(0, 0, 450, 450);
	for(int i = 0; i < count; ++i) a[i].draw(g);
    }
    public void start() { go = true; (new Thread(new MyRun())).start(); }
    public void stop() { go = false; }
    public void update(Graphics g) {
	int w = getSize().width, h = getSize().height;
	if(offimage == null) {
	    offimage = createImage(w, h);
	    offgraphics = offimage.getGraphics();
	}
	offgraphics.setColor(getBackground());
	offgraphics.fillRect(0, 0, w, h);
	paint(offgraphics);
	g.drawImage(offimage, 0, 0, this);
    }
    class MyRun implements Runnable {
	public void run() {
	    time = 0.001 * System.currentTimeMillis();
	    while(go) {
		try {Thread.sleep(100); }catch(Exception e) {}
		double dt = 0.001 * System.currentTimeMillis() - time;
		for(int i = 0; i < count ; ++i) a[i].addTime(dt);
		time += dt; repaint();
	    }
	}
    }
    interface Animation {
	public void addTime(double dt);
	public void draw(Graphics g);
    }

    static class FlyingCircle implements Animation {
	Color col;
	double gx, gy, rad, vx, vy;
	public FlyingCircle(Color c, double x, double y, double r, double vx1, double vy1) {
	    col = c; gx = x; gy = y; rad = r; vx = vx1; vy = vy1;
	}
	public void addTime(double dt) {
	    gx += vx*dt; gy += vy*dt;
	    if(gx < 0+rad && vx < 0 || gx > 400-rad && vx >0) {
               vx = -vx + 2*Math.random() ;
               col = new Color((int)(200*Math.random()+55),(int)(200*Math.random
()+55),(int)(200*Math.random()+55));
            }
	    if(gy < 0+rad && vy < 0 || gy > 400-rad && vy > 0) {
               vy = -vy -2*Math.random() ;
               col = new Color((int)(200*Math.random()+55),(int)(200*Math.random
()+55),(int)(200*Math.random()+55));
            }
	}
	public void draw(Graphics g) {
	    g.setColor(col);
	    g.fillOval((int)(gx-rad),(int)(gy-rad), (int)rad*2, (int)rad*2 );
	}
    }

    static class ShootingStar implements Animation {
	Color col;
        Star st;
	double gx, gy, rad, vx, vy;
	public ShootingStar(Color c, double x, double y, double r, double vx1, double vy1) {
            col = c; gx = x; gy = y; rad = r; vx = vx1; vy = vy1;

	}
        double vx0 = vx; double vy0 = vy;
	public void addTime(double dt) {
	    gx += vx*dt-5*Math.random(); gy += vy*dt+5*Math.random();vx += -200*dt; vy += 200*dt;
	    if(gx < 0 ) {gx += 400; col = Color.yellow; vx = vx0;}
	    if(gy < 0 ) {gy += 400; col = Color.yellow; vy = vy0; }
            if(gx > 400 ) {gx += -400; col = Color.yellow; vx = vx0;}
            if(gy > 400 ) {gy += -400; col = Color.yellow; vy = vy0;}
	}
	public void draw(Graphics g) {

	    g.setColor(col);
	    st = new Star(col, (int)gx, (int)gy, (int)rad);
	    st.draw(g);
	}
    }
}
class Star {
  Color col; int size;
  int[] xpos = new int[10];
  int[] ypos = new int[10];
  public Star(Color c, int x, int y, int s){
    col = c; size = s;
    for(int i = 0; i < 10; ++i){
       xpos[i] = (int)(x + 0.5*s + 0.5*s*Math.sin(Math.PI*i/5)+0.6);
       ypos[i] = (int)(y + 0.5*s - 0.5*s*Math.cos(Math.PI*i/5)+0.6);
       i = i +1;
       xpos[i] = (int)(x + 0.5*s + 0.18*s*Math.sin(Math.PI*i/5)+0.6);
       ypos[i] = (int)(y + 0.5*s - 0.18*s*Math.cos(Math.PI*i/5)+0.6);
    }
  }
  public void draw(Graphics g){
    g.setColor(col); g.fillPolygon(xpos, ypos, 10);
  }
}