import java.applet.Applet;
import java.awt.*;

public class Sample7B03 extends Applet {
    Image offimage;
    Graphics offgraphics;
    boolean go;
    double time, t0;
    static double ttotal;
    static final double end_time = 30.0;
    Animation[] a = new Animation[60];
    static double appear_p = 0;
    public void init() {
        ttotal = 0;
        for(int i = 0; i < a.length-1; ++i) { a[i] = new Spark(); }
        a[a.length-1] = new Core();
    }
    public void paint(Graphics g) {
        g.setColor(Color.black);
        g.fillRect(0, 0, 300, 400);
        for(int i = 0; i < a.length; ++i) a[i].draw(g);
    }
    public void start() { go = true; (new Thread(new MyRun())).start(); }
    public void stop() { go = false; }
    public void update(Graphics g) {
        int w = getSize().width, h = getSize().height;
        if(offimage == null) {
            offimage = createImage(w, h);
            offgraphics = offimage.getGraphics();
        }
        offgraphics.setColor(getBackground());
        offgraphics.fillRect(0, 0, w, h);
        paint(offgraphics);
        g.drawImage(offimage, 0, 0, this);
    }
    class MyRun implements Runnable {
        public void run() {
            time = 0.001 * System.currentTimeMillis();
            while(go && ttotal < (end_time+5)) {
                try { Thread.sleep(100); } catch(Exception e) { }
                double dt = 0.001 * System.currentTimeMillis() - time;
                for(int i = 0; i < a.length-1; ++i) a[i].addTime(dt);
                time += dt; ttotal += dt;
                double p = 0.6*Math.sin(Math.PI*ttotal/end_time);
                appear_p = p * p;
                repaint();
            }
        }
    }

    interface Animation {
        public void addTime(double dt);
        public void draw(Graphics g);
    }
    static class Core implements Animation {
        public void addTime(double dt) {
        }
        public void draw(Graphics g) {
            g.setColor(new Color(255, 219, 115));
            g.fillRect(149, 0, 3, 118);
            g.setColor(new Color(255, 231, 111));
            g.fillOval(147, 118, 7, 7);
        }
    }

    static class Spark implements Animation {
        double radius;
        int xc, yc;
        int x1, y1;
        int red = 0, green = 0, blue = 0;
        final int pnum = 15;    // ΉԂ̐
        final double lifespan = 0.5;    // Xp[N̎
        double age = 0;     // Xp[Nn܂Ă̎
        Petal[] petals = new Petal[pnum];   // Ή
//      final double appear_p = 0.01;   // Xp[Nm
        public Spark() { reNew(); age = lifespan + 1; }
        public void addTime(double dt) {
            age += dt;
            if(age > lifespan && Math.random() < appear_p) { reNew(); }
            else if(age > lifespan) { red = green = blue = 0; }
            else {
                red *= (lifespan-age)/lifespan;
                green *= (lifespan-age)/lifespan;
                blue *= (lifespan-age)/lifespan;
            }
        }
        public void reNew() {   // VXp[N蒼
            radius = 15 + 10*Math.random();
            double distance = 20 + 100 * Math.random();
            double theta = Math.PI*Math.random();
            double x0 = 150 + (distance * Math.cos(theta));
            double y0 = 120 + (distance * Math.sin(theta));
            xc = (int)x0; yc = (int)y0;
            double ratio = 0.4*(1+Math.random());
            x1 = (int)(150*ratio + x0*(1-ratio));
            y1 = (int)(120*ratio + y0*(1-ratio));
            age = 0;
            for(int i = 0; i < pnum; ++i) { petals[i] = new Petal(); }
            if(ttotal == 0 || ttotal > end_time) { red = green = blue = 0; }
            else { red = 255; green = 132; blue = 75; }
        }
        public void draw(Graphics g) {
            g.setColor(new Color(red, green, blue));
            g.drawLine(xc, yc, x1, y1);
            for(int i = 0; i < pnum; ++i) { petals[i].draw(g); }
        }
        class Petal {
            double length, degree;
            public Petal() {
                length = radius*(Math.random()*0.7+0.7);
                degree = 2*Math.PI*Math.random();
            }
            public void draw(Graphics g) {
                g.drawLine(xc, yc, (int)(xc+length*Math.cos(degree)),
                           (int)(yc+length*Math.sin(degree)));
            }
        }
    }
}