import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;

public class Sukiyaki3 extends Applet {
  static final int minX = 0, minY = 0, maxX = 300, maxY = 300;
  double time = 0;
  boolean running = false;
  Circle ci[] = new Circle[5];
  Circle box = new Circle(Color.black,50,50,45,30,30,0);
  int i;
  int gNumber = -1, nR;
  double angle,vel;
  int remain = 5;

  public void initiate() {
    for(i = 0; i < ci.length; i++) {
      vel = 60 + Math.random()*40;
      angle = Math.random()*2*Math.PI;
      ci[i] = new Circle(Color.getHSBColor((float)Math.random(),1,1),
                         5+(int)((maxX-10)*Math.random()),
                         5+(int)((maxY-10)*Math.random()),
                        (int)(vel*Math.cos(angle)),
(int)(vel*Math.sin(angle)),
                        5, (int)(10+Math.random()*3));
    }

  }

  public void init() {
    initiate();
    addMouseListener(new MouseAdapter() {
      public void mousePressed(MouseEvent event) {
        for(i = 0; i < ci.length; i++){
          if(ci[i].hit(event.getX(), event.getY())) {
            ci[i].grab();
            gNumber = i;
            break;
          }
        }
      }
      public void mouseReleased(MouseEvent event) {
        if(gNumber != -1){
          ci[gNumber].release();
          if(box.hit(event.getX(), event.getY())){
            ci[gNumber].vanish();
            remain --;
          }
          gNumber = -1;
          if(remain == 0) {
            initiate();
            remain = 5;
          }
        }
      }
    });
    addMouseMotionListener(new MouseMotionAdapter() {
      public void mouseDragged(MouseEvent event) {
        if(gNumber == -1) return;
        ci[gNumber].moveTo(
                           Math.min(maxX-ci[gNumber].getRadius(),
                                    Math.max(minX+ci[gNumber].getRadius(),
                                             event.getX())),
                           Math.min(maxY-ci[gNumber].getRadius(),
                                    Math.max(minY+ci[gNumber].getRadius(),
                                             event.getY())));
      }
    });
  }

  public void start() {
    if(!running) {
      (new Thread(new MyRun())).start();
      running = true;
    }
  }

  public void stop() {running = false;}

  class MyRun implements Runnable{
    public void run() {
      System.out.println("run");
      long t0 = System.currentTimeMillis();
      while(running) {

        try{
          Thread.sleep(100);
        }catch(Exception ex){}

        long t1 = System.currentTimeMillis();
        double dt = 0.001*(t1-t0);
        for(i = 0; i < 5; i++) {
          ci[i].passTime(dt);
        }
        box.passTime(dt);
        time += 0.001*(t1-t0);
        t0 = t1;
        time += dt;
        repaint();
      }
    }
  }

  public void paint(Graphics g) {
    box.draw(g);
    g.drawRect(0,0,maxX, maxY);
    for(i = 4; i >=0; i--){
      ci[i].draw(g);
    }
  }

  static class Circle {
    Color c;
    int cX,cY;
    double vX,vY;
    int R;
    int dr;
    int radius = R;
    double theta=0;
    boolean moving;
    boolean caught;
    boolean ex;

    public Circle(Color c, int cX, int cY, int vX, int vY,
                  int R, int dr) {
      this.c = c;
      this.cX = cX; this.cY = cY;
      this.vX = vX; this.vY = vY;
      this.R = R;
      this.dr = dr;
      moving = false;
      caught = false;
      ex = true;
    }
    public void draw(Graphics g) {
      if(ex){
        g.setColor(c);
        g.fillOval(cX - radius, cY - radius, radius*2, radius*2);
      }
    }
    public void passTime(double dt) {
      if(!caught) {
        if(moving) {
          if(theta > 3.14) {
            radius = R;
            moving = false;
            theta = 0;
          }
          else{
            radius = R + (int)(dr*(1-Math.cos(theta*2)));
            theta += dt;
          }
        }
        else {
          if(Math.random() < 0.03) {
            radius = R;
            theta = 0;
            moving = true;
          }
        }
        this.cX = this.cX+(int)(this.vX*dt); //ړ
        this.cY = this.cY+(int)(this.vY*dt);
        if(vX < 0 && cX <= minX+radius) {
          vX = -vX;
          cX = (int)((minX+radius)*2-cX); //߂荞݂CAˌ̍W
        }
        if(vX > 0 && cX >= maxX-radius) {
          vX = -vX;
          cX = (int)((maxX-radius)*2-cX);
        }
        if(vY < 0 && cY <= minY+radius) {
          vY = -vY;
          cY = (int)((minY+radius)*2-cY);
        }
        if(vY > 0 && cY >= maxY-radius) {
          vY = -vY;
          cY = (int)((maxY-radius)*2-cY);
        }
      }
    }

    public void moveTo(int X, int Y) {
      cX = X;
      cY = Y;
    }

    public int getRadius() {return radius;}

    public void grab() {caught = true;}
    public void release() {caught = false;}

    public boolean hit(int X, int Y) {
      return (X-cX)*(X-cX)+(Y-cY)*(Y-cY) <= radius*radius;
    }

    public void vanish() {ex = false;} //

  }
}
