import java.applet.Applet;
import java.awt.*;

public class  ball extends Applet {
    boolean go;
    double time;

    Animation[] a = new Animation[1000];
    public void init() {
	a[0] = new Ball(Color.green, 10, 390, 20, 3500, 4000, 50000);
	for(int i = 1; i <= 31; ++i) {
	    a[i] = new Circle(new Color(255, 255-4*i, 0), 5*i+5,
			      4*i+5, 5, 2500,2000);
	}
	for(int i = 32; i <= 90; ++i) {
	    a[i] = new Circle(new Color(255-4*(i-32), 0, 255), (i-32)+4,
			      2*(i-32)+100, 4, 1000, 2000);
	}
	for(int i = 91; i <= 120; ++i) {
	    a[i] = new Circle(new Color(0, 255, 255-8*(i-91)), 8*(i-91)+8,
			      352-2*(i-91), 8, 4000, -1000);
	}
    }
    public void paint(Graphics g) {
	for(int i = 0; i <= 120; ++i) a[i].draw(g);
    }
    public void start() { go = true; (new Thread(new MyRun())).start(); }
    public void stop() {go = false; }
    class MyRun implements Runnable {
	public void run() {
	    time = 0.0001 * System.currentTimeMillis() - time;
	    while(go) {
		try { Thread.sleep(1); } catch(Exception e) { }
		double dt = 0.0001 * System.currentTimeMillis() - time;
		for(int i = 0; i <= 120 ; ++i) a[i].addtime(dt);
		time += dt;
		repaint();
	    }
	}
    }

    interface Animation {
	public void addtime(double dt);
	public void draw(Graphics g);
    }
    static class Circle implements Animation {
	Color col;
	double gx, gy, rad, vx, vy;
	public Circle(Color c, double x, double y, double r,
		      double vx1, double vy1) {
	    col = c; gx = x; gy = y; rad = r; vx = vx1; vy = vy1;
	}
	public void addtime(double dt) {
	    gx += vx*dt; gy += vy*dt;
	    if(gx < rad && vx < 0 || gx > 800-rad && vx >0) vx = -vx;
	    if(gy < rad && vy < 0 || gy > 400-rad && vy >0) vy = -vy;
	}
	public void draw(Graphics g) {
	    g.setColor(col);
	    g.fillOval((int)(gx-rad), (int)(gy-rad), (int)rad*2, (int)rad*2);
	}
    }
    static class Ball implements Animation {
	Color col;
	double gx, gy, rad, vx, vy, ay;
	public Ball(Color c, double x, double y, double r,
		    double vx1, double vy1, double ay1) {
	    col = c; gx = x; gy = y; rad = r; vx = vx1; vy = vy1; ay = ay1;
	}
	public void addtime(double dt) {
	    gx += vx*dt; gy += vy*dt; vy += ay*dt;
	    if(gx < 10 && vx < 0 || gx > 790 && vx >0) vx = -vx;
	    if(gy > 390 && vy >0) vy = -vy;
	}
	public void draw(Graphics g) {
	    g.setColor(col);
	    g.fillOval((int)(gx-rad), (int)(gy-rad), (int)rad*2, (int)rad*2);
	}
    }
}
