import java.applet.Applet;
import java.awt.*;

/*
  <applet code="morphing01.java" width=400 height=300></applet>
*/

public class morphing01 extends Applet {
  Animation[] anim = new Animation[5];
  double time = 0;
  Image offimage;
  Graphics offgraphics;
  int count = 0, width, height;
  public void init() {
    width = getSize().width; height = getSize().height;
    anim[count++] = new Transform(width/2, height/4, 70, 40,
				  Color.red, "ctrc");
    anim[count++] = new Transform(width/4, height*0.7, 70, 40,
				  Color.green, "tcrt");
    anim[count++] = new Transform(width*0.75, height*0.7, 70, 40,
				  Color.blue, "rctr");
  }
  public void paint(Graphics g) {
    g.setColor(Color.white);
    g.fillRect(0, 0, width, height);
    for(int i = 0; i < count; i++) anim[i].draw(g);
  }
  public void update(Graphics g) {
    if(offimage == null) {
      offimage = createImage(width, height);
      offgraphics = offimage.getGraphics();
    }
    offgraphics.setColor(getBackground());
    offgraphics.fillRect(0, 0, width, height);
    paint(offgraphics);
    g.drawImage(offimage, 0, 0, this);
  }
  public void start() {
    (new Thread(new myRun())).start();
  }
  class myRun implements Runnable {
    public void run() {
      for(int i = 0; i < 150; i++) {
        try{ Thread.sleep(100); }
        catch(Exception e) {}
        double dt = 0.02;
        for(int j = 0; j < count; j++) anim[j].addTime(dt);
        repaint();
      }
    }
  }
  interface Animation {
    public void addTime(double dt);
    public void draw(Graphics g);
  }
  interface Figure {
    public double getX(int n);
    public double getY(int n);
  }
  static class Circle implements Figure {
    double[] x;
    double[] y;
    public Circle(double x0, double y0, double dia, int num) {
      x = new double[num]; y = new double[num];
      for(int i = 0; i < num; i++) {
        x[i] = x0 + dia/2*Math.cos(2*Math.PI*i/num);
        y[i] = y0 - dia/2*Math.sin(2*Math.PI*i/num);
      }
    }
    public double getX(int n) { return x[n]; }
    public double getY(int n) { return y[n]; }
  }
  static class Triangle implements Figure {
    double[] x;
    double[] y;
    public Triangle(double x0, double y0, double leng, int num) {
      x = new double[num]; y = new double[num];
      for(int i = 0; i < num; i++) {
        double p;
        switch(i*3/num) {
        case 0:
          p = Math.floor(i*3/num);
          x[i] = x0 + leng/2*(1-p);
          y[i] = y0 - leng/2/Math.sqrt(3)*(3*p - 1);
          break;
        case 1:
          p = Math.floor(i*3/num - 1);
          x[i] = x0 - leng/2*p;
          y[i] = y0 - leng/2/Math.sqrt(3)*(2 - 3*p);
          break;
        case 2:
          p = Math.floor(i*3/num - 2);
          x[i] = x0 + leng/2*(2*p - 1);
          y[i] = y0 + leng/2/Math.sqrt(3);
          break;
        }
      }
    }
    public double getX(int n) { return x[n]; }
    public double getY(int n) { return y[n]; }
  }
  static class Rectangle implements Figure {
    double[] x;
    double[] y;
    public Rectangle(double x0, double y0, double leng, int num) {
      x = new double[num]; y = new double[num];
      for(int i = 0; i < num; i++) {
        double p;
        switch(i*4/num) {
        case 0:
          p = Math.floor(i*4/num);
          x[i] = x0 + leng/2;
          y[i] = y0 - leng/2*(2*p - 1);
          break;
        case 1:
          p = Math.floor(i*4/num - 1);
          x[i] = x0 + leng/2*(1 - 2*p);
          y[i] = y0 - leng/2;
          break;
        case 2:
          p = Math.floor(i*4/num - 2);
          x[i] = x0 - leng/2;
          y[i] = y0 + leng/2*(2*p - 1);
          break;
        case 3:
          p = Math.floor(i*4/num - 3);
          x[i] = x0 - leng/2*(1 - 2*p);
          y[i] = y0 + leng/2;
          break;
        }
      }
    }
    public double getX(int n) { return x[n]; }
    public double getY(int n) { return y[n]; }
  }
  static class Transform implements Animation {
    Figure[] fig = new Figure[4];
    int count = 0;
    double q = 0;
    Color col = Color.black;
    int num;
    int mode = 0;
    public Transform(double x0, double y0, double leng, int num, Color col,
		     String str) {
	int n = Math.min(4, str.length());
	char c;
	for(int i = 0; i < n; i++) {
	    c = str.charAt(i);
	    if(c == 'c') {
		fig[count++] = new Circle(x0, y0, leng, num);
	    } else if(c == 't') {
		fig[count++] = new Triangle(x0, y0, leng, num);
	    } else if(c == 'r') {
		fig[count++] = new Rectangle(x0, y0, leng, num);
	    }
	}
        this.num = num;
        this.col = col;
    }
    public void addTime(double dt){
      if(q < 1) { q += dt; }
      else { q -= 1; q += dt; mode++; }
      if(q < 0) { q = 0; }
      float[] hsb = new float[3];
      Color.RGBtoHSB(col.getRed(), col.getGreen(), col.getBlue(), hsb);
      hsb[0] += 0.5*dt;
      if(hsb[0] > 1) hsb[0] -= 1;
      col = Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
    }
    public void draw(Graphics g) {
      int[] x = new int[num]; int[] y = new int[num];
      for(int i = 0; i < num; i++) {
        x[i] = (int)((1-q)*fig[mode].getX(i) + q*fig[mode+1].getX(i));
        y[i] = (int)((1-q)*fig[mode].getY(i) + q*fig[mode+1].getY(i));
      }
      g.setColor(col);
      g.fillPolygon(x, y, num);
    }
  }
}

