import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;

public class re8en4e extends Applet {
  static final int xmin = 0,xmax = 400,ymin = 0,ymax = 300;
  double time = 0.0;
  boolean running = false;
  Circle s1 = new Circle(Color.blue,100,100,20,15,0);
  Circle s2 = new Circle(Color.red,120,80,30,30,0);
  Circle s3 = new Circle(Color.yellow,200,140,40,60,0);

  public void paint(Graphics g) {
    s1.draw(g);
    s2.draw(g);
    s3.draw(g);
  }
  public void start(){
    if(!running) { (new Thread(new Myrun())).start();running = true; }
  }
  public void stop() {running = false; }

  class Myrun implements Runnable {
    public void run() {
      long t0 = System.currentTimeMillis();
      while(running){
        try { Thread.sleep(100); }catch(Exception ex) { }
        long t1 = System.currentTimeMillis();
        double dt = 0.001*(t1-t0);
        time += 0.001*(t1-t0); t0 = t1;
        s1.addTime(dt); s2.addTime(dt); s3.addTime(dt); time += dt; repaint();
      }
    }
  }
  static class Circle {
    Color col;
    double gx,gy,rad,vx,vy;

    public Circle(Color c, double x,double y,double r,double vx0,double vy0) {
      gx = x ; gy = y ; rad = r ; col = c ; vx = vx0 ; vy = vy0 ;
    }
    public void draw(Graphics g) {
      int len = (int)(rad*2);
      g.setColor(col);
      if( vx > 0 && gx <10 + xmin + rad) g.fillOval((int)(gx-rad),
          (int)(gy-rad),len*3/4,len);
      else if( vx < 0 && gx > -10 + xmax - rad) g.fillOval((int)(gx-rad+rad/4),
          (int)(gy-rad),len*3/4,len); 	
      else if( vy > 0 && gy < 15 + ymin + rad) g.fillOval((int)(gx-rad),
          (int)(gy-rad),len,len*3/4);
      else if( vy < 0 && gy > -15 +ymax - rad) g.fillOval((int)(gx-rad),
          (int)(gy-rad+rad/4),len,len*3/4);
      else g.fillOval((int)(gx-rad),(int)(gy-rad),len,len);
    }
    public  void addTime(double dt) {
      gx = gx + vx*dt ; gy = gy + vy*dt;
      if(vx < 0 && gx < xmin + rad) vx = -vx;
      else if(vx > 0 && gx > xmax - rad) vx = -vx;	
      else if(vy < 0 && gy < ymin + rad) vy = -vy;
      else if(vy > 0 && gy > ymax - rad) vy = -vy;
      else { vy = vy + 100*dt; }
    }
  }
}
