import java.awt.*;
import javax.swing.*;

public class report7b1 extends JApplet {
     Image buf;
     boolean go;
     double time;
     Animation[] a = new Animation[20];
     int count = 0;
     public void init() {
	a[count++] = new ChangingRect(new Color(0, 0, 130), 150, 100, 300,200);
	a[count++] = new Flyingstar(Color.white, 50, 0, 5, 1, 10, 100, 50);
	a[count++] = new Flyingstar(Color.yellow, 0, 0, 5, 2, 10, 100, 50);
	a[count++] = new Shiningstar(Color.yellow, 260, 10, 4, 2, 8);
	a[count++] = new Shiningstar(Color.white, 100, 20, 5, 2, 8);
	a[count++] = new Shiningstar(Color.white, 200, 40, 10, 2, 8);
	a[count++] = new Shiningstar(Color.yellow, 280, 100, 6, 2, 8);
	a[count++] = new Shiningstar(Color.white, 130, 180, 7, 2, 8);
	a[count++] = new Shiningstar(Color.white, 30, 90, 3, 1, 8);
	a[count++] = new Shiningstar(Color.yellow, 50, 30, 12, 1, 8);
	a[count++] = new Shiningstar(Color.white, 140, 100, 5, 1, 8);
	a[count++] = new Shiningstar(Color.yellow, 20, 160, 11, 1, 8);
	a[count++] = new Shiningstar(Color.white, 290, 180, 8, 1, 8);
	a[count++] = new Shiningstar(Color.yellow, 230, 140, 9, 1, 8);
     }
     public void update(Graphics g) {
	if(buf == null) { buf = createImage(getWidth(), getHeight()); }
	Graphics2D g2 = (Graphics2D)buf.getGraphics();
	g2.clearRect(0, 0, getWidth(),getHeight()); paint(g2);
	g.drawImage(buf, 0, 0,this);
     }
     public void paint(Graphics g) {
	Graphics2D g2 = (Graphics2D)g;
	for(int i = 0; i < count; ++i) a[i].draw(g2);
     }
     public void start() { go = true; (new Thread(new MyRun())).start();
}
     public  void stop() { go = false; }
     class MyRun implements Runnable {
	public void run() {
	    time = 0.001 * System.currentTimeMillis();
	    while(go) {
		try { Thread.sleep(100); } catch(Exception e) { }
		double dt = 0.001 * System.currentTimeMillis() - time;
		for(int i = 0; i < count; ++i) a[i].addTime(dt);
		time += dt; repaint();
	    }
	}
     }
     interface Animation {
	public void addTime(double dt);
	public void draw(Graphics2D g);
     }
     static class Flyingstar implements Animation {
	Paint col;
	double gx, gy, rad1, rad2, vx, vy, time = 0.0;
	int num;
	int[] xpts, ypts;
	public Flyingstar(Paint c, double x, double y, int n, double a, double
b, double vx1, double vy1) {
	    col = c; gx = x; gy = y; num = n; rad1 = a; rad2 = b; vx = vx1; vy
= vy1;
	    xpts = new int[2*n]; ypts = new int[2*n];
	}
	public void addTime(double dt) {
	    gx += vx*dt; gy += vy*dt;
	}
	public void draw(Graphics2D g) {
	    double dt = Math.PI/num;
	    for(int i = 0; i < 2*num; ++i) {
		double r = (double)(2.0*rad1+rad1*Math.sin(time))/4;
		if(i%2 == 0) r = (double)(2.0*rad2+rad2*Math.sin(time))/4;
		xpts[i] = (int)(gx+r*Math.cos(time+i*dt));
          	ypts[i] = (int)(gy+r*Math.sin(time+i*dt));
	    }
	    g.setPaint(col);
	    g.fillPolygon(xpts, ypts, 2*num);
	}
     }
     static class Shiningstar implements Animation {
	Color col;
	double gx, gy, rad1, rad2, time = 0.0;
	int num;
	int[] xpts, ypts;
	public Shiningstar(Color c, double x, double y, int n, double a,
double b) {
	    col = c; gx = x; gy = y; num = n; rad1 = a; rad2 = b;
	    xpts = new int[2*n]; ypts = new int[2*n];
	}
	public void addTime(double dt) { time += dt; }
	public void draw(Graphics2D g) {
	    double dt = Math.PI/num;
	    for(int i = 0; i < 2*num; ++i) {
		double r = (double)(2.0*rad1+rad1*Math.sin(time))/4;
		if(i%2 == 0) r = (double)(2.0*rad2+rad2*Math.sin(time))/4;
		xpts[i] = (int)(gx+r*Math.cos(time+i*dt));
		ypts[i] = (int)(gy+r*Math.sin(time+i*dt));
	    }

	    g.setColor(col);
	    g.fillPolygon(xpts, ypts, 2*num);
	}
     }
     static class ChangingRect implements Animation {
	Paint col;
	double xpos, ypos, width, height, time = 0.0;
	public ChangingRect(Paint c, double gx, double gy, double w, double h)
{
	    col = c; xpos = gx; ypos = gy; width = w; height = h;
	}
	public void addTime(double dt) { time += dt; }
	public void draw(Graphics2D g) {
	    g.setPaint(col);
	    g.fillRect((int)(xpos-width/2), (int)(ypos-height/2),
(int)(width), (int)(height));
	}
     }
}
