import java.applet.Applet;
import java.awt.*;

public class report7b9 extends Applet {
    boolean go;
    double time;
    Animation[] a = new Animation[20];
    int count = 0;
    public void init() {
	a[count++] = new Figure1(Color.white, 300, 250, 80, 40, 100, 100, 0, 20);
	a[count++] = new Figure2(Color.black, 300, 250, -80, -40, 100, 100, 0, 20);
	a[count++] = new DCircle(new Color(40, 20, 100), 80, 200, 50, 8);
	a[count++] = new UCircle(new Color(30, 30, 200), 190, 300, 50, 12);
	a[count++] = new DCircle(new Color(30, 200, 20), 300, 200, 50, 10);
	a[count++] = new UCircle(new Color(200, 30, 30), 410, 300, 50, 20);
	a[count++] = new DCircle(new Color(20, 100, 100), 520, 200, 50, 9);
    }
    public void paint(Graphics g) {
	for(int i = 0; i < count; ++i) a[i].draw(g);
    }

    Image offimage;
    Graphics offgraphics;
    public void update(Graphics g) {
	int w = getSize().width, h = getSize().height; //
	if(offimage == null) {   //
	    offimage = createImage(w, h);         //
	    offgraphics = offimage.getGraphics(); //
	}
	offgraphics.setColor(new Color(70, 70, 70));  //
	offgraphics.fillRect(0, 0, w, h);   //
	paint(offgraphics);                 //
	g.drawImage(offimage, 0, 0, this);  //
    }

    public void start() { go = true; (new Thread(new MyRun())).start(); }
    public void stop() { go = false; }
    class MyRun implements Runnable {
	public void run() {
	    time = 0.001 * System.currentTimeMillis();
	    while(go) {
		try { Thread.sleep(100); } catch(Exception e) {}
		double dt = 0.001 * System.currentTimeMillis() - time;
		for(int i = 0; i < count; ++i) a[i].addTime(dt);
		time += dt; repaint();
	    }
	}
    }

    interface Animation {
	public void addTime(double dt);
	public void draw(Graphics g);
    }
    static class DCircle implements Animation {
	Color col, d;
	double vy, theta, omega;
	int gx, gy, length, x, y, rad, sign;
	public DCircle(Color c, int xz, int yz, int r, double o) {
	    d = c; gx = xz; gy = yz; length = r; theta = 0; omega = o; vy = 0;
	}
	public void setColor(Color a) {
	    col = a;
	}
	public void addTime(double dt) {
	    theta += omega*dt*10*Math.PI/180;
	    rad = (int)(length * Math.sin(theta));
	    sign = (int)Math.pow(-1, (int)(theta/(Math.PI)));
	    if(sign == 1) {col = Color.white;}
	    else {col = d;}
	    if(rad < 0) rad = -rad;
	    vy += 90*dt;
	    gy += vy*dt;
	    if(gy + rad > 500 && vy > 0) vy = -vy;
	    x = gx - rad; y = gy - rad;
	}
	public void draw(Graphics g) {
	    g.setColor(col);
	    g.fillOval(x, y, 2*rad, 2*rad);
	}
    }
    static class UCircle implements Animation {
	Color col, d;
	double vy, theta, omega;
	int gx, gy, length, x, y, rad, sign;
	public UCircle(Color c, int xz, int yz, int r ,double o) {
	    d = c; gx = xz; gy = yz; length = r; theta = 0; omega = o; vy = 0;
	}
	public void setColor(Color a) {
	    col = a;
	}
	public void addTime(double dt) {
	    theta += omega*dt*10*Math.PI/180;
	    rad = (int)(length * Math.sin(theta));
	    sign = (int)Math.pow(-1, (int)(theta/(Math.PI)));
	    if(sign == 1) {col = Color.white;}
	    else {col = d;}
	    if(rad < 0) rad = -rad;
	    vy += -90*dt;
	    gy += vy*dt;
	    if(gy - rad < 0 && vy <=  0) vy = -vy;
	    x = gx - rad; y = gy - rad;
	}
	public void draw(Graphics g) {
	    g.setColor(col);
	    g.fillOval(x, y, 2*rad, 2*rad);
	}
    }
    static class Figure1 implements Animation {
	Color col;
	double gx, gy, vx, vy, length, width, theta, omega;
	int []x = new int[4];
	int []y = new int[4];
	int sign = 1;
	public Figure1(Color c, double xz, double yz, double speedx, double speedy,
		       double w, double l, double t, double o) {
	    col = c; gx = xz; gy = yz; vx = speedx; vy = speedy;
	    width = w; length = l; theta = t; omega = o;
	}
	public void addTime(double dt) {
	    theta += omega*dt*10*Math.PI/180*sign;
	    gx += dt*vx;
	    gy += dt*vy;
	    x[0] = (int)(gx + width + length*Math.cos(theta)/2);
	    y[0] = (int)(gy + width - length*Math.sin(theta)/2);
	    x[1] = (int)(gx - width + length*Math.cos(theta)/2);
	    y[1] = (int)(gy - width - length*Math.sin(theta)/2);
	    x[2] = (int)(gx - width - length*Math.cos(theta)/2);
	    y[2] = (int)(gy - width + length*Math.sin(theta)/2);
	    x[3] = (int)(gx + width - length*Math.cos(theta)/2);
	    y[3] = (int)(gy + width + length*Math.sin(theta)/2);
	    for(int i = 0; i < 4; ++i) {
		if(x[i] < 0|| x[i] > 600) {
		    vx = -vx; sign = -sign;
		    break;
		}
		if(y[i] < 0 || y[i] > 500) {
		    vy = -vy; sign = -sign;
		    break;
		}
	    }
	}
	public void draw(Graphics g) {
	    g.setColor(col);
	    g.drawPolygon(x, y, 4);
	}
    }
    static class Figure2 implements Animation {
	Color col;
	double gx, gy, vx, vy, length, width, theta, omega;
	int []x = new int[4];
	int []y = new int[4];
	int sign = 1;
	public Figure2(Color c, double xz, double yz, double speedx, double speedy,
		       double w, double l, double t, double o) {
	    col = c; gx = xz; gy = yz; vx = speedx; vy = speedy;
	    width = w; length = l; theta = t; omega = o;
	}
	public void addTime(double dt) {
	    theta += omega*dt*10*Math.PI/180*sign;
	    gx += dt*vx;
	    gy += dt*vy;
	    x[0] = (int)(gx + width - length*Math.cos(theta)/2);
	    y[0] = (int)(gy + width - length*Math.sin(theta)/2);
	    x[1] = (int)(gx - width - length*Math.cos(theta)/2);
	    y[1] = (int)(gy - width - length*Math.sin(theta)/2);
	    x[2] = (int)(gx - width + length*Math.cos(theta)/2);
	    y[2] = (int)(gy - width + length*Math.sin(theta)/2);
	    x[3] = (int)(gx + width + length*Math.cos(theta)/2);
	    y[3] = (int)(gy + width + length*Math.sin(theta)/2);
	    for(int i = 0; i < 4; ++i) {
		if(x[i] < 0|| x[i] > 600) {
		    vx = -vx; sign = -sign;
		    break;
		}
		if(y[i] < 0 || y[i] > 500) {
		    vy = -vy; sign = -sign;
		    break;
		}
	    }
	}
	public void draw(Graphics g) {
	    g.setColor(col);
	    g.drawPolygon(x, y, 4);
	}
    }
}