
import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;

public class report8b2 extends Applet {
  static final int xmin = 0, xmax = 550, ymin = 0, ymax = 400;
  double time = 0.0;
  boolean running = false;
  Circle s1 = new Circle(Color.red, 50, 20, 27, 3, 5);
  Circle cur = null;
  long t0;

  public void paint(Graphics g) {
   s1.draw(g); }
  public void init() {
    setBackground(Color.orange);
    addMouseListener(new MouseAdapter() {
      public void mousePressed(MouseEvent evt) {
        if(s1.hit(evt.getX(), evt.getY())) {
          cur = s1; cur.setGrab(true); t0 = System.currentTimeMillis();
        } else {
          cur = null;
        }
      }
      public void mouseReleased(MouseEvent evt) {
        if(cur != null) cur.setGrab(false);
      }
    });
    addMouseMotionListener(new MouseMotionAdapter() {
      public void mouseDragged(MouseEvent evt) {
        if(cur == null) return;
        long t1 = System.currentTimeMillis();
        double dt = 0.001*(t1-t0); t0 = t1;
        cur.moveTo(evt.getX(), evt.getY(), dt); repaint();
      }
    });
    addKeyListener(new KeyAdapter() {
      public void keyPressed(KeyEvent evt) {
        if(evt.getKeyChar() == '-') stop();
        if(evt.getKeyChar() == '+') start();
      }
    });
  }
  public void start() {
    if(!running) { running = true; (new Thread(new MyRun())).start(); }
  }
  public void stop() { running = false; }

  class MyRun implements Runnable {
    public void run() {
      long t0 = System.currentTimeMillis();
       while(running) {
         try { Thread.sleep(100); } catch(Exception ex) { }
         long t1 = System.currentTimeMillis();
         double dt = 0.001*(t1 - t0);
         time += 0.001*(t1 - t0); t0 = t1;
         s1.addTime(dt); time += dt; repaint();
       }
    }
  }
  public class Circle {
    Color col;
    double gx, gy, rad, vx, vy;
    boolean grabbed = false;
    Font fn = new Font("Serif",Font.BOLD,15);
    Font fnt = new Font("Helvetica",Font.BOLD,15);
    int k = 300;
    int i = 0;
    public Circle(Color c, double x, double y, double r,
                  double vx0, double vy0)  {
      gx = x; gy = y; rad = r; col = c; vx = vx0; vy = vy0;
    }
    public void draw(Graphics g) {
      int len = (int)(rad*2);
      g.setColor(Color.white); g.fillRect(10, 300, 100, 100);
      g.setColor(Color.black); g.setFont(fn);
      g.drawString("V[gʒu", 10, 300); g.setFont(fnt);
      g.clearRect(0, 0, 550, 30);
      g.drawString("score  " + i, 10, 20);
      if(i >= 100000){ g.drawString("level 3",450, 20);}
      else if(i >=50000){ g.drawString("level 2",450, 20);}
      else if(i >=10000){ g.drawString("level 1",450, 20);}
      else if(i >=0){ g.drawString("level 0",450, 20);}
      g.setColor(col); g.fillOval((int)(gx-rad), (int)(gy-rad), len, len);
      g.setColor(Color.green); g.fillRect(450, 100, 100, 10);
      g.setColor(Color.white);
      g.drawLine(450, 110, 470, 200);
      g.drawLine(450, 110, 470, 200); g.drawLine(460, 110, 480, 200);
      g.drawLine(470, 110, 490, 200); g.drawLine(480, 110, 500, 200);
      g.drawLine(490, 110, 510, 200); g.drawLine(500, 110, 520, 200);
      g.drawLine(510, 110, 530, 200); g.drawLine(550, 110, 530, 200);
      g.drawLine(540, 110, 520, 200); g.drawLine(530, 110, 510, 200);
      g.drawLine(520, 110, 500, 200); g.drawLine(510, 110, 490, 200);
      g.drawLine(500, 110, 480, 200); g.drawLine(490, 110, 470, 200);
      g.drawLine(480, 110, 465, 175); g.drawLine(470, 110, 460, 150);
      g.drawLine(460, 110, 455, 125); g.drawLine(520, 110, 535, 175);
      g.drawLine(530, 110, 540, 150); g.drawLine(540, 110, 545, 125);

    }
    public void setGrab(boolean b) { grabbed = b; }
    public void moveTo(double x, double y, double dt) {
      if(!grabbed) return;
      vx = 0.7*vx + 0.3*(x-gx)/dt; gx = x;
      vy = 0.7*vy + 0.3*(y-gy)/dt; gy = y;
    }
    public void addTime(double dt) {
      if(grabbed) return;
      vy = vy + k*dt; gx = gx + vx*dt; gy = gy + vy*dt;
      if(vx < 0 && gx < (xmin + rad)) vx = -vx;
      if(vx > 0 && gx > (xmax - rad)) vx = -vx/2;
      if(vy < 0 && gy < (ymin + rad)) vy = -vy/10;
      if(vy > 0 && gy > (ymax - rad)) vy = -vy;
      if(vx > 300) vx = 300;
      if(vy > 300) vy = 300;
      if(gx > 450 && gy < 210 && gy > 200) i = i + 1000;
      if(vx > 0 && gy > 100 && gy < 220 && gx > (450 - rad) &&
         gx < (500 - rad)) vx = -vx;
      if(vy < 0 && gx > 450 && gx < 550 && gy < (220 + rad) &&
         gy > (200 + rad)) vy = -vy;
      if(vy > 0 && gx > 450 && gx < 550 && gy > (200 - rad) &&
         gy < (230 - rad)) vy = -vy;
      if(vx < 0 && gy > 100 && gy < 220 && gx < (470 + rad) &&
         gx > (450 + rad)) vx = -vx;
      if(gx > 450 && gy > 350) vx = -50;
      if(i >= 100000) { k = 100;}
      else if (i >= 50000 ) { k = 1000;}
      else if (i >= 10000 ) { k = 500;}
    }
    public double getX() { return gx; }
    public double getY() { return gy; }
    public boolean hit(double x, double y) {
      return (x-gx)*(x-gx) + (y-gy)*(y-gy) <= rad*rad;
    }
  }
}
