import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;

public class report8b3 extends Applet {
  static final int xmin = 0, xmax = 500, ymin = 0, ymax = 500;
  double time = 0.0;
  boolean running = false;
  Circle s1 = new Circle(Color.blue, 100, 40, 20, 23, 35);
  Circle s2 = new Circle(Color.red, 250, 190, 30, -10, -25);

  public void paint(Graphics g) { s2.draw(g); s1.draw(g); }
  public void start() {
    if(!running) { running = true; (new Thread(new MyRun())).start(); }
  }
  public void stop() { running = false; }

  class MyRun implements Runnable {
    public void run() {
      long t0 = System.currentTimeMillis();
       while(running) {
         try { Thread.sleep(100); } catch(Exception ex) { }
         long t1 = System.currentTimeMillis();
         double dt = 0.001*(t1-t0);
         time += 0.001*(t1-t0); t0 = t1;
         s1.addTime(dt); s2.addTime(dt);
         s1.setVX(s1.getVX() - (s1.getX()-s2.getX())*dt/s1.getM());
         s2.setVX(s2.getVX() + (s1.getX()-s2.getX())*dt/s2.getM());
         s1.setVY(s1.getVY() - (s1.getY()-s2.getY())*dt/s1.getM());
         s2.setVY(s2.getVY() + (s1.getY()-s2.getY())*dt/s2.getM());
         double dis = (s1.getX()-s2.getX())*(s1.getX()-s2.getX())+
                  (s1.getY()-s2.getY())*(s1.getY()-s2.getY());
         if((s1.getVX()-s2.getVX())*(s1.getX()-s2.getX())<0 &&
            (s1.getVY()-s2.getVY())*(s1.getY()-s2.getY())<0 &&
            dis<(s1.getR()+s2.getR())*(s1.getR()+s2.getR())) {
           double ehx = (s1.getX()-s2.getX())/Math.sqrt(dis);
           double ehy = (s1.getY()-s2.getY())/Math.sqrt(dis);
           double v0 = ehx*s1.getVX()+ehy*s1.getVY();
           double vt = ehy*s1.getVX()-ehx*s1.getVY();
           double V0 = ehx*s2.getVX()+ehy*s2.getVY();
           double Vt = ehy*s1.getVX()-ehx*s2.getVY();
           double v1 = ((s1.getM()-s2.getM())*v0+2*s2.getM()*V0)/
                                 (s1.getM()+s2.getM());
           double V1 = ((s2.getM()-s1.getM())*V0+2*s1.getM()*v0)/
                                 (s1.getM()+s2.getM());
           s1.setVX(ehx*v1+ehy*vt);
           s1.setVY(ehy*v1-ehx*vt);
           s2.setVX(ehx*V1+ehy*Vt);
           s2.setVY(ehy*v1-ehx*Vt);
         }
         time += dt; repaint();
       }
    }
  }
  static class Circle {
    Color col;
    double gx, gy, rad, vx, vy;
    public double getX() { return gx; }
    public double getY() { return gy; }
    public double getR() { return rad; }
    public double getM() { return rad*rad*rad/1000; }
    public void setVX(double x) { vx = x; }
    public void setVY(double y) { vy = y; }
    public double getVX() { return vx; }
    public double getVY() { return vy; }
    public Circle(Color c, double x, double y, double r,
                    double vx0, double vy0)  {
      gx = x; gy = y; rad = r; col = c; vx = vx0; vy = vy0;
    }
    public void draw(Graphics g) {
      int len = (int)(rad*2);
      g.setColor(col); g.fillOval((int)(gx-rad), (int)(gy-rad), len,len);
    }
    public void addTime(double dt) {
      gx = gx + vx*dt; gy = gy + vy*dt;
      if(vx < 0 && gx < xmin+rad) vx = -vx;
      if(vx > 0 && gx > xmax-rad) vx = -vx;
      if(vy < 0 && gy < ymin+rad) vy = -vy;
      if(vy > 0 && gy > ymax-rad) vy = -vy;
    }
  }
}
