import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;

public class Sample93 extends Applet {

     int apex = 6;
     Choice choiceA;
     ItemAdp itemAdp = new ItemAdp();

     public void init() {
	setBackground(Color.lightGray);
	choiceA = new Choice();
	for(int ct=3;ct<=100;ct++){
	   choiceA.add(""+ct);
	}

	add(choiceA);
	add(new Label("apex   "));
	choiceA.select(apex-3);
         choiceA.addItemListener(itemAdp);
    }

     public void paint(Graphics g) {
	g.setColor(Color.black);
	g.fillRect(0,0,getSize().width,getSize().height);
	drawUni(g,apex);
     }

     class ItemAdp implements ItemListener {
         public void itemStateChanged(ItemEvent e) {
             if (e.getSource() == choiceA) {
                 apex = choiceA.getSelectedIndex() +3;
                 repaint();

             }
         }
     }

     public void drawUni(Graphics g, int apex){
	if(apex<3)return;
	g.setColor(Color.white);
	int width=getSize().width;
	int height=getSize().height;
	int centerX=width/2;
	int centerY=height/2+13;
	int range=Math.min(width,height-20)/2-10;
	int x[]=new int[apex];
	int y[]=new int[apex];
	Color color[]=new Color[apex];
	for(int ct=0;ct<apex;ct++){
	    x[ct]=(int)Math.round(centerX-range*Math.sin(Math.PI*ct*2/apex));
	    y[ct]=(int)Math.round(centerY-range*Math.cos(Math.PI*ct*2/apex));
             color[ct]=Color.getHSBColor((float)Math.random(),0.5f,1.0f);

	}
	for(int point=0;point<apex;point++){
	    g.setColor(color[point]);
	    for(int ct=1;ct<10;ct++){
		g.drawLine((int)Math.round(x[point]*ct/10+centerX*(10-ct)/10),
	       		   (int)Math.round(y[point]*ct/10+centerY*(10-ct)/10),

(int)Math.round(x[(point+1)%apex]*(10-ct)/10+centerX*ct/10),

(int)Math.round(y[(point+1)%apex]*(10-ct)/10+centerY*ct/10));
	    }
	}
	for(int point=0;point<apex;point++){
	    g.setColor(color[point]);
	    g.drawLine(x[point],y[point],centerX,centerY);
	}
	return;

     }
}